/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.spongepowered.configurate.transformation;

import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.io.leangen.geantyref.TypeToken;
import squaremap.libraries.org.spongepowered.configurate.ConfigurateException;
import squaremap.libraries.org.spongepowered.configurate.ConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.NodePath;

@FunctionalInterface
public interface TransformAction {
    public static TransformAction remove() {
        return (path, value) -> {
            value.raw(null);
            return null;
        };
    }

    public static TransformAction rename(Object newKey) {
        return (path, value) -> {
            Object[] arr = path.array();
            if (arr.length == 0) {
                throw new ConfigurateException(value, "The root node cannot be renamed!");
            }
            arr[arr.length - 1] = newKey;
            return arr;
        };
    }

    public static <V> TransformAction set(TypeToken<V> type, @Nullable V value) {
        return (path, node) -> {
            node.set(type, value);
            return null;
        };
    }

    public static <V> TransformAction set(TypeToken<V> type, Supplier<@Nullable V> valueSupplier) {
        return (path, value) -> {
            value.set(type, valueSupplier.get());
            return null;
        };
    }

    public static <V> TransformAction set(Class<V> type, Supplier<V> valueSupplier) {
        return (path, value) -> {
            value.set(type, valueSupplier.get());
            return null;
        };
    }

    public Object @Nullable [] visitPath(NodePath var1, ConfigurationNode var2) throws ConfigurateException;
}

