/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Key {
    private static final IntPredicate CHARACTER_PREDICATE = value -> value == 95 || value == 45 || value >= 97 && value <= 122 || value >= 65 && value <= 90 || value >= 48 && value <= 57 || value == 46;
    private final String key;

    private Key(@NonNull String key) {
        if (!Key.validKey(key)) {
            throw Key.invalidKey(key);
        }
        this.key = key;
    }

    public static @NonNull Key of(@NonNull String key) {
        return new Key(key);
    }

    public static @NonNull Key key(@NonNull String key) {
        return new Key(key);
    }

    public @NonNull String getKey() {
        return this.key;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @Nullable Key key1 = (Key)o;
        return this.key.equals(key1.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public @NonNull String toString() {
        return this.key;
    }

    private static boolean validKey(@NonNull String key) {
        int length = key.length();
        for (int i = 0; i < length; ++i) {
            if (CHARACTER_PREDICATE.test(key.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static @NonNull IllegalArgumentException invalidKey(@NonNull String key) {
        return new IllegalArgumentException(String.format("Non [a-zA-Z0-9._-] character in key '%s'", key));
    }
}

