/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api.marker;

import java.awt.Color;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class MarkerOptions {
    private static final MarkerOptions DEFAULT_OPTIONS = MarkerOptions.builder().build();
    private final boolean stroke;
    private final Color strokeColor;
    private final int strokeWeight;
    private final double strokeOpacity;
    private final boolean fill;
    private final Color fillColor;
    private final double fillOpacity;
    private final FillRule fillRule;
    private final String clickTooltip;
    private final String hoverTooltip;

    private MarkerOptions(boolean stroke, @NonNull Color strokeColor, int strokeWeight, double strokeOpacity, boolean fill, @Nullable Color fillColor, double fillOpacity, @NonNull FillRule fillRule, @Nullable String clickTooltip, @Nullable String hoverTooltip) {
        this.stroke = stroke;
        this.strokeColor = strokeColor;
        this.strokeWeight = strokeWeight;
        this.strokeOpacity = strokeOpacity;
        this.fill = fill;
        this.fillColor = fillColor;
        this.fillOpacity = fillOpacity;
        this.fillRule = fillRule;
        this.clickTooltip = clickTooltip;
        this.hoverTooltip = hoverTooltip;
    }

    public static @NonNull MarkerOptions defaultOptions() {
        return DEFAULT_OPTIONS;
    }

    public boolean stroke() {
        return this.stroke;
    }

    public @NonNull Color strokeColor() {
        return this.strokeColor;
    }

    public int strokeWeight() {
        return this.strokeWeight;
    }

    public double strokeOpacity() {
        return this.strokeOpacity;
    }

    public boolean fill() {
        return this.fill;
    }

    public @Nullable Color fillColor() {
        return this.fillColor;
    }

    public double fillOpacity() {
        return this.fillOpacity;
    }

    public @NonNull FillRule fillRule() {
        return this.fillRule;
    }

    public @Nullable String clickTooltip() {
        return this.clickTooltip;
    }

    public @Nullable String hoverTooltip() {
        return this.hoverTooltip;
    }

    public @NonNull Builder asBuilder() {
        return new Builder(this.stroke, this.strokeColor, this.strokeWeight, this.strokeOpacity, this.fill, this.fillColor, this.fillOpacity, this.fillRule, this.clickTooltip, this.hoverTooltip);
    }

    public static @NonNull Builder builder() {
        return new Builder();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @Nullable MarkerOptions that = (MarkerOptions)o;
        return this.stroke == that.stroke && this.strokeWeight == that.strokeWeight && Double.compare(that.strokeOpacity, this.strokeOpacity) == 0 && this.fill == that.fill && Double.compare(that.fillOpacity, this.fillOpacity) == 0 && this.strokeColor.equals(that.strokeColor) && Objects.equals(this.fillColor, that.fillColor) && this.fillRule == that.fillRule && Objects.equals(this.clickTooltip, that.clickTooltip) && Objects.equals(this.hoverTooltip, that.hoverTooltip);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stroke, this.strokeColor, this.strokeWeight, this.strokeOpacity, this.fill, this.fillColor, this.fillOpacity, this.fillRule, this.clickTooltip, this.hoverTooltip});
    }

    public static enum FillRule {
        NONZERO,
        EVENODD;

    }

    public static final class Builder {
        private boolean stroke = true;
        private Color strokeColor = Color.BLUE;
        private int strokeWeight = 3;
        private double strokeOpacity = 1.0;
        private boolean fill = true;
        private Color fillColor = null;
        private double fillOpacity = 0.2;
        private FillRule fillRule = FillRule.EVENODD;
        private String clickTooltip = null;
        private String hoverTooltip = null;

        private Builder() {
        }

        private Builder(boolean stroke, @NonNull Color strokeColor, int strokeWeight, double strokeOpacity, boolean fill, @Nullable Color fillColor, double fillOpacity, @NonNull FillRule fillRule, @Nullable String clickTooltip, @Nullable String hoverTooltip) {
            this.stroke = stroke;
            this.strokeColor = strokeColor;
            this.strokeWeight = strokeWeight;
            this.strokeOpacity = strokeOpacity;
            this.fill = fill;
            this.fillColor = fillColor;
            this.fillOpacity = fillOpacity;
            this.fillRule = fillRule;
            this.clickTooltip = clickTooltip;
            this.hoverTooltip = hoverTooltip;
        }

        public @NonNull Builder stroke(boolean stroke) {
            this.stroke = stroke;
            return this;
        }

        public @NonNull Builder strokeColor(@NonNull Color color) {
            this.strokeColor = color;
            return this;
        }

        public @NonNull Builder strokeWeight(int weight) {
            this.strokeWeight = weight;
            return this;
        }

        public @NonNull Builder strokeOpacity(double opacity) {
            this.strokeOpacity = opacity;
            return this;
        }

        public @NonNull Builder fill(boolean fill) {
            this.fill = fill;
            return this;
        }

        public @NonNull Builder fillColor(@NonNull Color color) {
            this.fillColor = color;
            return this;
        }

        public @NonNull Builder fillOpacity(double opacity) {
            this.fillOpacity = opacity;
            return this;
        }

        public @NonNull Builder fillRule(@NonNull FillRule fillRule) {
            this.fillRule = fillRule;
            return this;
        }

        public @NonNull Builder clickTooltip(@Nullable String tooltip) {
            this.clickTooltip = tooltip;
            return this;
        }

        public @NonNull Builder hoverTooltip(@Nullable String tooltip) {
            this.hoverTooltip = tooltip;
            return this;
        }

        public @NonNull MarkerOptions build() {
            return new MarkerOptions(this.stroke, this.strokeColor, this.strokeWeight, this.strokeOpacity, this.fill, this.fillColor, this.fillOpacity, this.fillRule, this.clickTooltip, this.hoverTooltip);
        }
    }
}

