/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.api.marker;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.api.marker.IPolygon;
import xyz.jpenilla.squaremap.api.marker.Marker;

public final class MultiPolygon
extends Marker {
    private final List<MultiPolygonPart> subPolygons;

    MultiPolygon(@NonNull List<MultiPolygonPart> subPolygons) {
        this.subPolygons = new ArrayList<MultiPolygonPart>(subPolygons);
    }

    public static @NonNull MultiPolygonPart part(Point ... points) {
        return MultiPolygon.part(Arrays.asList(points), Collections.emptyList());
    }

    @SafeVarargs
    public static @NonNull MultiPolygonPart part(@NonNull List<Point> points, List<Point> ... negativeSpace) {
        return MultiPolygon.part(points, Arrays.asList(negativeSpace));
    }

    public static @NonNull MultiPolygonPart part(@NonNull List<Point> points, @NonNull List<List<Point>> negativeSpace) {
        return new MultiPolygonPart(points, negativeSpace);
    }

    public @NonNull List<MultiPolygonPart> subPolygons() {
        return this.subPolygons;
    }

    public void subPolygons(@NonNull List<MultiPolygonPart> subPolygons) {
        this.subPolygons.clear();
        this.subPolygons.addAll(subPolygons);
    }

    public void subPolygons(MultiPolygonPart ... subPolygons) {
        this.subPolygons(Arrays.asList(subPolygons));
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        @Nullable MultiPolygon that = (MultiPolygon)o;
        return this.markerOptionsMatch(that) && this.subPolygons.equals(that.subPolygons);
    }

    public int hashCode() {
        return Objects.hash(this.markerOptions(), this.subPolygons);
    }

    public static final class MultiPolygonPart
    implements IPolygon {
        private final List<Point> mainPolygon;
        private final List<List<Point>> negativeSpace;

        private MultiPolygonPart(@NonNull List<Point> points, @NonNull List<List<Point>> negativeSpace) {
            this.mainPolygon = new ArrayList<Point>(points);
            this.negativeSpace = new ArrayList<List<Point>>(negativeSpace);
        }

        @Override
        public @NonNull List<List<Point>> negativeSpace() {
            return this.negativeSpace;
        }

        @Override
        public @NonNull List<Point> mainPolygon() {
            return this.mainPolygon;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            @Nullable MultiPolygonPart that = (MultiPolygonPart)o;
            return this.mainPolygon.equals(that.mainPolygon) && this.negativeSpace.equals(that.negativeSpace);
        }

        public int hashCode() {
            return Objects.hash(this.mainPolygon, this.negativeSpace);
        }
    }
}

