/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.kyori.adventure.text.Component;
import net.minecraft.server.level.ServerPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.api.PlayerManager;
import xyz.jpenilla.squaremap.common.ServerAccess;

@DefaultQualifier(value=NonNull.class)
public abstract class AbstractPlayerManager
implements PlayerManager {
    private final ServerAccess serverAccess;
    private final Set<UUID> hidden = ConcurrentHashMap.newKeySet();

    protected AbstractPlayerManager(ServerAccess serverAccess) {
        this.serverAccess = serverAccess;
    }

    public boolean otherwiseHidden(ServerPlayer player) {
        return false;
    }

    public abstract Component displayName(ServerPlayer var1);

    protected abstract boolean persistentHidden(ServerPlayer var1);

    protected abstract void persistentHidden(ServerPlayer var1, boolean var2);

    @Override
    public final void hide(UUID uuid, boolean persistent) {
        this.hide(this.requirePlayer(uuid), persistent);
    }

    public final void hide(ServerPlayer player, boolean persistent) {
        if (persistent) {
            this.persistentHidden(player, true);
        }
        this.hidden.add(player.getUUID());
    }

    @Override
    public final void show(UUID uuid, boolean persistent) {
        this.show(this.requirePlayer(uuid), persistent);
    }

    public final void show(ServerPlayer player, boolean persistent) {
        if (persistent) {
            this.persistentHidden(player, false);
        }
        this.hidden.remove(player.getUUID());
    }

    @Override
    public final void hidden(UUID uuid, boolean hide, boolean persistent) {
        this.hidden(this.requirePlayer(uuid), hide, persistent);
    }

    @Override
    public final boolean hidden(UUID uuid) {
        return this.hidden(this.requirePlayer(uuid));
    }

    public final void reload() {
        this.hidden.clear();
    }

    public final boolean hidden(ServerPlayer player) {
        return this.hidden.contains(player.getUUID()) || this.persistentHidden(player);
    }

    public final void hidden(ServerPlayer player, boolean hide, boolean persistent) {
        if (hide) {
            this.hide(player, persistent);
        } else {
            this.show(player, persistent);
        }
    }

    private ServerPlayer requirePlayer(UUID uuid) {
        @Nullable ServerPlayer player = this.serverAccess.player(uuid);
        if (player == null) {
            throw new IllegalArgumentException("Player with uuid '" + String.valueOf(uuid) + "' is not online.");
        }
        return player;
    }
}

