/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.CommandManager;
import squaremap.libraries.org.incendo.cloud.component.CommandComponent;
import squaremap.libraries.org.incendo.cloud.component.DefaultValue;
import squaremap.libraries.org.incendo.cloud.component.TypedCommandComponent;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.help.HelpHandler;
import squaremap.libraries.org.incendo.cloud.help.result.CommandEntry;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.AudienceProvider;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.MinecraftHelp;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import squaremap.libraries.org.incendo.cloud.parser.standard.StringParser;
import squaremap.libraries.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;

@DefaultQualifier(value=NonNull.class)
public final class HelpCommand
extends SquaremapCommand {
    private final MinecraftHelp<Commander> minecraftHelp;
    private final TypedCommandComponent<Commander, String> helpQueryArgument;

    @Inject
    private HelpCommand(Commands commands) {
        super(commands);
        this.minecraftHelp = HelpCommand.createMinecraftHelp(commands.commandManager());
        this.helpQueryArgument = HelpCommand.createHelpQueryArgument(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("help", new String[0]).commandDescription(RichDescription.richDescription(Messages.HELP_COMMAND_DESCRIPTION)).argument(this.helpQueryArgument).permission("squaremap.command.help").handler(this::executeHelp));
    }

    private void executeHelp(CommandContext<Commander> context) {
        this.minecraftHelp.queryCommands((String)context.get(this.helpQueryArgument), context.sender());
    }

    private static TypedCommandComponent<Commander, String> createHelpQueryArgument(Commands commands) {
        HelpHandler<Commander> commandHelpHandler = commands.commandManager().createHelpHandler();
        BlockingSuggestionProvider.Strings suggestions = (context, input) -> commandHelpHandler.queryRootIndex((Commander)context.sender()).entries().stream().map(CommandEntry::syntax).toList();
        return CommandComponent.ofType(String.class, "query").parser(StringParser.greedyStringParser()).suggestionProvider(suggestions).optional().defaultValue(DefaultValue.constant("")).description(RichDescription.richDescription(Messages.HELP_QUERY_ARGUMENT_DESCRIPTION)).build();
    }

    private static MinecraftHelp<Commander> createMinecraftHelp(CommandManager<Commander> manager) {
        return MinecraftHelp.builder().commandManager(manager).audienceProvider(AudienceProvider.nativeAudience()).commandPrefix(String.format("/%s help", Config.MAIN_COMMAND_LABEL)).colors(MinecraftHelp.helpColors(TextColor.color((int)5964031), (TextColor)NamedTextColor.WHITE, TextColor.color((int)12593407), (TextColor)NamedTextColor.GRAY, (TextColor)NamedTextColor.DARK_GRAY)).messageProvider(HelpCommand::helpMessage).build();
    }

    private static Component helpMessage(Commander sender, String key, Map<String, String> args) {
        return Messages.componentMessage("command.message.help." + key).withPlaceholders(args.entrySet().stream().map(e -> Components.placeholder((String)e.getKey(), e.getValue())).collect(Collectors.toList()));
    }
}

