/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.description.Description;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlatformCommands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.exception.CommandCompleted;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.EntityScheduler;

@DefaultQualifier(value=NonNull.class)
public final class HideShowCommands
extends SquaremapCommand {
    private final PlatformCommands platformCommands;
    private final EntityScheduler entityScheduler;

    @Inject
    private HideShowCommands(Commands commands, PlatformCommands platformCommands, EntityScheduler entityScheduler) {
        super(commands);
        this.platformCommands = platformCommands;
        this.entityScheduler = entityScheduler;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("hide", new String[0]).commandDescription(RichDescription.richDescription(Messages.HIDE_COMMAND_DESCRIPTION)).permission("squaremap.command.hide").handler(this::executeHide));
        this.commands.registerSubcommand(builder -> builder.literal("hide", new String[0]).required("player", this.platformCommands.singlePlayerSelectorParser(), (Description)RichDescription.richDescription(Messages.OPTIONAL_PLAYER_ARGUMENT_DESCRIPTION)).commandDescription(RichDescription.richDescription(Messages.HIDE_COMMAND_DESCRIPTION)).permission("squaremap.command.hide.others").handler(this::executeHide));
        this.commands.registerSubcommand(builder -> builder.literal("show", new String[0]).commandDescription(RichDescription.richDescription(Messages.SHOW_COMMAND_DESCRIPTION)).permission("squaremap.command.show").handler(this::executeShow));
        this.commands.registerSubcommand(builder -> builder.literal("show", new String[0]).required("player", this.platformCommands.singlePlayerSelectorParser(), (Description)RichDescription.richDescription(Messages.OPTIONAL_PLAYER_ARGUMENT_DESCRIPTION)).commandDescription(RichDescription.richDescription(Messages.SHOW_COMMAND_DESCRIPTION)).permission("squaremap.command.show.others").handler(this::executeShow));
    }

    private void executeHide(CommandContext<Commander> context) {
        ServerPlayer target = this.platformCommands.extractPlayer("player", context).orElseThrow(() -> CommandCompleted.withMessage(Messages.CONSOLE_MUST_SPECIFY_PLAYER));
        Commander sender = context.sender();
        this.entityScheduler.scheduleFor((Entity)target, () -> {
            if (context.get(Commands.PLAYER_MANAGER).hidden(target.getUUID())) {
                this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_ALREADY_HIDDEN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
                return;
            }
            context.get(Commands.PLAYER_MANAGER).hide(target.getUUID(), true);
            this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_HIDDEN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
        });
    }

    private void executeShow(CommandContext<Commander> context) {
        ServerPlayer target = this.platformCommands.extractPlayer("player", context).orElseThrow(() -> CommandCompleted.withMessage(Messages.CONSOLE_MUST_SPECIFY_PLAYER));
        Commander sender = context.sender();
        this.entityScheduler.scheduleFor((Entity)target, () -> {
            if (!context.get(Commands.PLAYER_MANAGER).hidden(target.getUUID())) {
                this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_NOT_HIDDEN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
                return;
            }
            context.get(Commands.PLAYER_MANAGER).show(target.getUUID(), true);
            this.entityScheduler.scheduleFor(sender, () -> sender.sendMessage(Messages.PLAYER_SHOWN.withPlaceholders(new TagResolver[]{Components.playerPlaceholder(target)})));
        });
    }
}

