/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.PlayerCommander;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;

@DefaultQualifier(value=NonNull.class)
public final class LinkCommand
extends SquaremapCommand {
    @Inject
    private LinkCommand(Commands commands) {
        super(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("link", new String[0]).commandDescription(RichDescription.richDescription(Messages.LINK_COMMAND_DESCRIPTION)).permission("squaremap.command.link").handler(this::showLink));
    }

    private void showLink(CommandContext<Commander> ctx) {
        StringBuilder link;
        HashMap<String, String> params = new HashMap<String, String>();
        Commander commander = ctx.sender();
        if (commander instanceof PlayerCommander) {
            PlayerCommander player = (PlayerCommander)commander;
            params.put("uuid", ((UUID)player.get(Identity.UUID).orElseThrow()).toString().replace("-", ""));
        }
        boolean first = (link = new StringBuilder(Config.WEB_ADDRESS)).toString().indexOf(63) == -1;
        for (Map.Entry entry : params.entrySet()) {
            if (first) {
                link.append('?');
                first = false;
            } else {
                link.append('&');
            }
            link.append((String)entry.getKey());
            link.append('=');
            link.append((String)entry.getValue());
        }
        ctx.sender().sendMessage(Messages.LINK_COMMAND_LINK_FORMAT.withPlaceholders(new TagResolver[]{Placeholder.parsed((String)"link", (String)link.toString())}));
    }
}

