/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.network;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.Collection;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class NetworkingHandler {
    public static final ResourceLocation CHANNEL = ResourceLocation.parse((String)"squaremap:client");
    private final WorldManager worldManager;
    private final ServerAccess serverAccess;
    private final Set<UUID> clientUsers;

    @Inject
    public NetworkingHandler(WorldManager worldManager, ServerAccess serverAccess) {
        this.worldManager = worldManager;
        this.serverAccess = serverAccess;
        this.clientUsers = ConcurrentHashMap.newKeySet();
    }

    public void onDisconnect(UUID playerUuid) {
        this.clientUsers.remove(playerUuid);
    }

    public void handleIncoming(ServerPlayer player, byte[] data, Predicate<MapItemSavedData> isVanillaMap) {
        ByteArrayDataInput in = NetworkingHandler.in(data);
        int action = in.readInt();
        switch (action) {
            case 0: {
                this.clientUsers.add(player.getUUID());
                this.sendServerData(player);
                break;
            }
            case 1: {
                int id = in.readInt();
                this.sendMapData(player, id, isVanillaMap);
            }
        }
    }

    private void sendServerData(ServerPlayer player) {
        ByteArrayDataOutput out = NetworkingHandler.out();
        out.writeInt(0);
        out.writeInt(3);
        out.writeInt(200);
        out.writeUTF(Config.WEB_ADDRESS);
        Collection<MapWorldInternal> mapWorlds = this.worldManager.worlds();
        out.writeInt(mapWorlds.size());
        for (MapWorldInternal mapWorld : mapWorlds) {
            out.writeUTF(mapWorld.identifier().asString());
            out.writeUTF(Util.levelWebName(mapWorld.serverLevel()));
            out.writeInt(mapWorld.config().ZOOM_MAX);
            out.writeInt(mapWorld.config().ZOOM_DEFAULT);
            out.writeInt(mapWorld.config().ZOOM_EXTRA);
        }
        out.writeUTF(player.level().dimension().location().toString());
        NetworkingHandler.send(player, out);
    }

    private void sendMapData(ServerPlayer player, int id, Predicate<MapItemSavedData> isVanillaMap) {
        ByteArrayDataOutput data = this.mapData(player, id, isVanillaMap);
        NetworkingHandler.send(player, data);
    }

    private ByteArrayDataOutput mapData(ServerPlayer player, int id, Predicate<MapItemSavedData> isVanillaMap) {
        ByteArrayDataOutput out = NetworkingHandler.out();
        out.writeInt(1);
        out.writeInt(3);
        @Nullable MapItemSavedData mapData = player.level().getMapData(new MapId(id));
        if (mapData == null) {
            out.writeInt(-1);
            out.writeInt(id);
            return out;
        }
        @Nullable ServerLevel world = this.serverAccess.level(Util.worldIdentifier(mapData.dimension.location()));
        if (world == null) {
            out.writeInt(-2);
            out.writeInt(id);
            return out;
        }
        if (!isVanillaMap.test(mapData)) {
            out.writeInt(-3);
            out.writeInt(id);
            return out;
        }
        out.writeInt(200);
        out.writeInt(id);
        out.writeByte((int)mapData.scale);
        out.writeInt(mapData.centerX);
        out.writeInt(mapData.centerZ);
        out.writeUTF(world.dimension().location().toString());
        return out;
    }

    public void worldChanged(ServerPlayer player) {
        if (!this.clientUsers.contains(player.getUUID())) {
            return;
        }
        ByteArrayDataOutput out = NetworkingHandler.out();
        out.writeInt(2);
        out.writeInt(3);
        out.writeInt(200);
        out.writeUTF(player.level().dimension().location().toString());
        NetworkingHandler.send(player, out);
    }

    private static void send(ServerPlayer player, ByteArrayDataOutput out) {
    }

    private static ByteArrayDataOutput out() {
        return ByteStreams.newDataOutput();
    }

    private static ByteArrayDataInput in(byte[] bytes) {
        return ByteStreams.newDataInput((byte[])bytes);
    }
}

