/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ForkJoinPool;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.phys.Vec3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Provider;
import xyz.jpenilla.squaremap.api.HtmlComponentSerializer;
import xyz.jpenilla.squaremap.common.AbstractPlayerManager;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.httpd.JsonCache;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class UpdatePlayers
implements Runnable {
    private static final String JSON_PATH = "/tiles/players.json";
    private final Provider<ComponentFlattener> flattener;
    private final AbstractPlayerManager playerManager;
    private final ServerAccess serverAccess;
    private final ConfigManager configManager;
    private final JsonCache jsonCache;
    private @Nullable Map<String, Object> lastData = null;

    @Inject
    private UpdatePlayers(Provider<ComponentFlattener> flattener, AbstractPlayerManager playerManager, ServerAccess serverAccess, ConfigManager configManager, JsonCache jsonCache) {
        this.flattener = flattener;
        this.playerManager = playerManager;
        this.serverAccess = serverAccess;
        this.configManager = configManager;
        this.jsonCache = jsonCache;
    }

    @Override
    public void run() {
        @Nullable Map<String, Object> prev = this.lastData;
        Map<String, Object> data = this.collectData();
        this.lastData = data;
        ForkJoinPool.commonPool().execute(() -> {
            if (prev == null || !prev.equals(data)) {
                String json = Util.gson().toJson((Object)data);
                this.jsonCache.put(JSON_PATH, json);
            }
        });
    }

    private Map<String, Object> collectData() {
        ArrayList players = new ArrayList();
        HtmlComponentSerializer htmlComponentSerializer = HtmlComponentSerializer.withFlattener(this.flattener.get());
        this.serverAccess.levels().forEach(world -> {
            WorldConfig worldConfig = this.configManager.worldConfig((ServerLevel)world);
            world.players().forEach(player -> {
                if (worldConfig.PLAYER_TRACKER_HIDE_SPECTATORS && player.gameMode.getGameModeForPlayer() == GameType.SPECTATOR) {
                    return;
                }
                if (worldConfig.PLAYER_TRACKER_HIDE_INVISIBLE && player.isInvisible()) {
                    return;
                }
                if (worldConfig.PLAYER_TRACKER_HIDE_MAP_INVISIBILITY_EQUIPMENT && UpdatePlayers.hasMapInvisibilityItemEquipped((Player)player)) {
                    return;
                }
                if (this.playerManager.hidden((ServerPlayer)player) || this.playerManager.otherwiseHidden((ServerPlayer)player)) {
                    return;
                }
                HashMap<String, Object> playerEntry = new HashMap<String, Object>();
                Vec3 playerLoc = player.position();
                playerEntry.put("name", player.getGameProfile().name());
                if (worldConfig.PLAYER_TRACKER_USE_DISPLAY_NAME) {
                    playerEntry.put("display_name", htmlComponentSerializer.serialize(this.playerManager.displayName((ServerPlayer)player)));
                }
                playerEntry.put("uuid", player.getUUID().toString().replace("-", ""));
                playerEntry.put("world", Util.levelWebName(world));
                if (worldConfig.PLAYER_TRACKER_ENABLED) {
                    playerEntry.put("x", Mth.floor((double)playerLoc.x()));
                    playerEntry.put("y", Mth.floor((double)playerLoc.y()));
                    playerEntry.put("z", Mth.floor((double)playerLoc.z()));
                    playerEntry.put("yaw", Math.round(player.getYHeadRot()));
                    if (worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_ARMOR) {
                        playerEntry.put("armor", UpdatePlayers.armorPoints(player));
                    }
                    if (worldConfig.PLAYER_TRACKER_NAMEPLATE_SHOW_HEALTH) {
                        playerEntry.put("health", (int)player.getHealth());
                    }
                }
                players.add(playerEntry);
            });
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("players", players);
        map.put("max", this.serverAccess.maxPlayers());
        return map;
    }

    private static int armorPoints(ServerPlayer player) {
        @Nullable AttributeInstance attribute = player.getAttribute(Attributes.ARMOR);
        return attribute == null ? 0 : (int)attribute.getValue();
    }

    private static boolean hasMapInvisibilityItemEquipped(Player player) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (slot == EquipmentSlot.MAINHAND || slot == EquipmentSlot.OFFHAND || !player.getItemBySlot(slot).is(ItemTags.MAP_INVISIBILITY_EQUIPMENT)) continue;
            return true;
        }
        return false;
    }
}

