/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task.render;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.assistedinject.Assisted;
import squaremap.libraries.com.google.inject.assistedinject.AssistedInject;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.ServerAccess;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.data.RegionCoordinate;
import xyz.jpenilla.squaremap.common.task.render.AbstractRender;
import xyz.jpenilla.squaremap.common.task.render.RenderProgress;
import xyz.jpenilla.squaremap.common.util.RegionFileDirectoryResolver;
import xyz.jpenilla.squaremap.common.util.SpiralIterator;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshotProviderFactory;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityLimitImpl;

@DefaultQualifier(value=NonNull.class)
public final class FullRender
extends AbstractRender {
    private final RegionFileDirectoryResolver regionFileDirectoryResolver;
    private final ServerAccess serverAccess;
    private final int wait;
    private int maxRadius = 0;
    private int totalChunks;
    private int totalRegions;

    @AssistedInject
    private FullRender(@Assisted MapWorldInternal world, @Assisted int wait, ChunkSnapshotProviderFactory chunkSnapshotProviderFactory, RegionFileDirectoryResolver regionFileDirectoryResolver, ServerAccess serverAccess) {
        super(world, chunkSnapshotProviderFactory);
        this.regionFileDirectoryResolver = regionFileDirectoryResolver;
        this.wait = wait;
        this.serverAccess = serverAccess;
    }

    @AssistedInject
    private FullRender(@Assisted MapWorldInternal world, ChunkSnapshotProviderFactory chunkSnapshotProviderFactory, RegionFileDirectoryResolver regionFileDirectoryResolver, ServerAccess serverAccess) {
        this(world, 0, chunkSnapshotProviderFactory, regionFileDirectoryResolver, serverAccess);
    }

    @Override
    protected void render() {
        try {
            this.serverAccess.blockSleep();
            this.render0();
        }
        finally {
            this.serverAccess.allowSleep();
        }
    }

    private void render0() {
        Map<RegionCoordinate, Boolean> regions;
        Map<RegionCoordinate, Boolean> resumedMap;
        if (this.wait > 0) {
            FullRender.sleep(this.wait * 1000);
        }
        if ((resumedMap = this.mapWorld.renderManager().readRenderProgress()) != null) {
            Logging.info(Messages.LOG_RESUMED_RENDERING, "world", this.mapWorld.identifier().asString());
            regions = resumedMap;
            int count = (int)regions.values().stream().filter(bool -> bool).count();
            this.processedRegions.set(count);
            this.processedChunks.set(this.countCompletedChunks(regions));
        } else {
            Logging.info(Messages.LOG_STARTED_FULLRENDER, "world", this.mapWorld.identifier().asString());
            Logging.logger().info(Messages.LOG_SCANNING_REGION_FILES);
            List<RegionCoordinate> regionFiles = this.getRegions();
            Iterator<RegionCoordinate> spiral = SpiralIterator.region(0, 0, this.maxRadius);
            int failsafe = 0;
            regions = new LinkedHashMap<RegionCoordinate, Boolean>();
            while (spiral.hasNext() && this.running()) {
                if (failsafe > 500000) {
                    regionFiles.forEach(region -> regions.put((RegionCoordinate)region, false));
                    break;
                }
                RegionCoordinate region2 = spiral.next();
                if (regionFiles.contains(region2)) {
                    regions.put(region2, false);
                    failsafe = 0;
                    continue;
                }
                ++failsafe;
            }
        }
        if (!this.running()) {
            return;
        }
        VisibilityLimitImpl visibility = this.mapWorld.visibilityLimit();
        this.totalRegions = regions.size();
        this.totalChunks = regions.keySet().stream().mapToInt(visibility::countChunksInRegion).sum();
        Logging.info(Messages.LOG_FOUND_TOTAL_REGION_FILES, "total", regions.size());
        this.progress = RenderProgress.printProgress(this);
        for (Map.Entry<RegionCoordinate, Boolean> entry : regions.entrySet()) {
            if (!this.running()) break;
            if (entry.getValue().booleanValue()) continue;
            this.mapRegion(entry.getKey());
            entry.setValue(true);
            this.processedRegions.incrementAndGet();
            if (!this.running()) continue;
            this.mapWorld.renderManager().saveRenderProgress(regions);
        }
    }

    private int countCompletedChunks(Map<RegionCoordinate, Boolean> regions) {
        VisibilityLimitImpl visibility = this.mapWorld.visibilityLimit();
        return regions.entrySet().stream().filter(Map.Entry::getValue).mapToInt(entry -> visibility.countChunksInRegion((RegionCoordinate)entry.getKey())).sum();
    }

    @Override
    public int totalChunks() {
        return this.totalChunks;
    }

    @Override
    public int totalRegions() {
        return this.totalRegions;
    }

    private List<RegionCoordinate> getRegions() {
        LinkedHashSet<RegionCoordinate> regions = new LinkedHashSet<RegionCoordinate>();
        for (Path path : this.getRegionFiles()) {
            int z;
            int x;
            if (path.toFile().length() == 0L) continue;
            String[] split = path.getFileName().toString().split("\\.");
            try {
                x = Integer.parseInt(split[1]);
                z = Integer.parseInt(split[2]);
            }
            catch (NumberFormatException ex) {
                Logging.logger().warn("Failed to parse coordinates for region file '{}' (file name path: '{}')", (Object)path, (Object)path.getFileName(), (Object)ex);
                continue;
            }
            RegionCoordinate region = new RegionCoordinate(x, z);
            if (!this.mapWorld.visibilityLimit().shouldRenderRegion(region)) continue;
            this.maxRadius = Math.max(Math.max(this.maxRadius, Math.abs(x)), Math.abs(z));
            regions.add(region);
        }
        return List.copyOf(regions);
    }

    private Path[] getRegionFiles() {
        Path[] pathArray;
        block8: {
            Path regionFolder = this.regionFileDirectoryResolver.resolveRegionFileDirectory(this.level);
            Logging.debug(() -> "Listing region files for directory '" + String.valueOf(regionFolder) + "'...");
            Stream<Path> stream = Files.list(regionFolder);
            try {
                pathArray = (Path[])stream.filter(file -> {
                    String fileName = file.getFileName().toString();
                    if (!fileName.startsWith("r.")) {
                        return false;
                    }
                    return fileName.endsWith(".mca") || fileName.endsWith(".linear");
                }).toArray(Path[]::new);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to list region files in directory '" + String.valueOf(regionFolder.toAbsolutePath()) + "'", ex);
                }
            }
            stream.close();
        }
        return pathArray;
    }
}

