/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;

@DefaultQualifier(value=NonNull.class)
public final class Components {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.miniMessage();
    private static final Pattern SPECIAL_CHARACTERS_PATTERN = Pattern.compile("[^\\s\\w\\-]");

    public static MiniMessage miniMessage() {
        return MINI_MESSAGE;
    }

    public static Component miniMessage(String miniMessage) {
        return Components.miniMessage().deserialize((Object)miniMessage);
    }

    public static Component miniMessage(String miniMessage, TagResolver ... templates) {
        return Components.miniMessage().deserialize(miniMessage, templates);
    }

    public static TagResolver.Single placeholder(String name, ComponentLike value) {
        return Placeholder.component((String)name, (ComponentLike)value);
    }

    public static TagResolver.Single placeholder(String name, Object value) {
        return Placeholder.unparsed((String)name, (String)value.toString());
    }

    public static TagResolver.Single worldPlaceholder(MapWorldInternal mapWorld) {
        return Components.placeholder("world", mapWorld.identifier().asString());
    }

    public static TagResolver.Single worldPlaceholder(ServerLevel level) {
        return Components.placeholder("world", level.dimension().location());
    }

    public static TagResolver.Single playerPlaceholder(ServerPlayer player) {
        return Components.placeholder("player", player.getGameProfile().name());
    }

    public static Component highlightSpecialCharacters(Component component, TextColor highlightColor) {
        return Components.highlight(component, SPECIAL_CHARACTERS_PATTERN, highlightColor);
    }

    public static Component highlight(Component component, Pattern highlight, TextColor highlightColor) {
        return component.replaceText(config -> {
            config.match(highlight);
            config.replacement(match -> match.color(highlightColor));
        });
    }
}

