/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    @SafeVarargs
    public static <T> @NonNull T firstNonNullOrThrow(@NonNull Supplier<String> exceptionMessage, T ... elements) {
        for (T element : elements) {
            if (element == null) continue;
            return element;
        }
        throw new IllegalArgumentException(exceptionMessage.get());
    }

    public static @Nullable Field findField(@NonNull Class<?> clazz, @NonNull String name) {
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
    }

    public static @Nullable Method findMethod(@NonNull Class<?> clazz, @NonNull String name, Class<?> ... parameterTypes) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
    }

    public static @Nullable Class<?> findClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    public static @NonNull Class<?> needClass(@NonNull String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static @NonNull Field needField(@NonNull Class<?> clazz, String ... names) {
        return ReflectionUtil.firstNonNullOrThrow(() -> String.format("Could not locate field in class '%s' with any of the following names: %s", clazz.getName(), Arrays.toString(names)), (Field[])Arrays.stream(names).map(name -> ReflectionUtil.findField(clazz, name)).toArray(Field[]::new));
    }

    public static @NonNull Method needMethod(@NonNull Class<?> clazz, @NonNull List<@NonNull String> names, Class<?> ... parameterTypes) {
        return ReflectionUtil.firstNonNullOrThrow(() -> String.format("Could not locate method in class '%s' with any of the following names: [%s]", clazz.getName(), String.join((CharSequence)", ", new CharSequence[0])), (Method[])names.stream().map(name -> ReflectionUtil.findMethod(clazz, name, parameterTypes)).toArray(Method[]::new));
    }

    public static @Nullable Object invokeOrThrow(@NonNull Method method, @Nullable Object instance, Object ... args) {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to invoke method", e);
        }
    }

    public static boolean isStatic(@NonNull Member member) {
        return Modifier.isStatic(member.getModifiers());
    }
}

