/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.nio.file.Path;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelResource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.com.google.inject.Singleton;

@DefaultQualifier(value=NonNull.class)
public interface RegionFileDirectoryResolver {
    public Path resolveRegionFileDirectory(ServerLevel var1);

    @Singleton
    public static class Vanilla
    implements RegionFileDirectoryResolver {
        @Inject
        private Vanilla() {
        }

        @Override
        public Path resolveRegionFileDirectory(ServerLevel level) {
            Path worldPath = level.getServer().getWorldPath(LevelResource.ROOT);
            return DimensionType.getStorageFolder((ResourceKey)level.dimension(), (Path)worldPath).resolve("region");
        }
    }
}

