/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.jar.Manifest;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public record UpdateChecker(Logger logger, String githubRepo) {
    public void checkVersion() {
        this.logger.info(Messages.UPDATE_CHECKER_FETCHING_VERSION_INFORMATION);
        @Nullable Manifest manifest = Util.manifest(UpdateChecker.class);
        if (manifest == null) {
            this.logger.warn("Failed to locate manifest, cannot check for updates.");
            return;
        }
        String currentVersion = manifest.getMainAttributes().getValue("squaremap-version");
        if (currentVersion.contains("-SNAPSHOT")) {
            this.checkSnapshot(manifest);
            return;
        }
        this.checkRelease(currentVersion);
    }

    private void checkSnapshot(Manifest manifest) {
        Distance result;
        String gitHash = manifest.getMainAttributes().getValue("squaremap-commit");
        String branch = manifest.getMainAttributes().getValue("squaremap-branch");
        Distance distance = result = this.fetchDistance(branch, gitHash);
        Objects.requireNonNull(distance);
        Distance distance2 = distance;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Distance.UpToDate.class, Distance.Behind.class, Distance.Failure.class, Distance.Ahead.class, Distance.Diverged.class, Distance.UnknownCommit.class}, (Object)distance2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Distance.UpToDate $ = (Distance.UpToDate)distance2;
                break;
            }
            case 1: {
                Distance.Behind behind = (Distance.Behind)distance2;
                this.logger.info(Messages.UPDATE_CHECKER_BEHIND_BRANCH.replace("<branch>", branch).replace("<behind>", String.valueOf(behind.result())));
                this.logger.info(Messages.UPDATE_CHECKER_DOWNLOAD_DEV_BUILDS.replace("<link>", "https://jenkins.jpenilla.xyz/job/squaremap/"));
                break;
            }
            case 2: {
                Distance.Failure failure = (Distance.Failure)distance2;
                this.logger.warn("Error obtaining version information", (Throwable)failure.reason());
                break;
            }
            case 3: {
                Distance.Ahead $ = (Distance.Ahead)distance2;
                this.logger.info("Commit '{}' is ahead of branch '{}', local build?", (Object)gitHash, (Object)branch);
                break;
            }
            case 4: {
                Distance.Diverged $ = (Distance.Diverged)distance2;
                this.logger.info("Commit '{}' is diverged from branch '{}', local build?", (Object)gitHash, (Object)branch);
                break;
            }
            case 5: {
                Distance.UnknownCommit $ = (Distance.UnknownCommit)distance2;
                this.logger.info(Messages.UPDATE_CHECKER_UNKNOWN_COMMIT.replace("<commit>", gitHash));
            }
        }
    }

    private void checkRelease(String currentVersion) {
        Releases releases;
        try {
            releases = this.fetchReleases();
        }
        catch (IOException e) {
            this.logger.warn("Failed to list releases, cannot check for updates.", (Throwable)e);
            return;
        }
        String ver = "v" + currentVersion;
        if (releases.releaseList().getFirst().equals(ver)) {
            return;
        }
        int versionsBehind = releases.releaseList().indexOf(ver);
        this.logger.info(Messages.UPDATE_CHECKER_BEHIND_RELEASES.replace("<behind>", String.valueOf(versionsBehind == -1 ? "?" : Integer.valueOf(versionsBehind))));
        this.logger.info(Messages.UPDATE_CHECKER_DOWNLOAD_RELEASE.replace("<latest>", releases.releaseList().getFirst()).replace("<link>", releases.releaseUrls().get(releases.releaseList().getFirst())));
    }

    private Releases fetchReleases() throws IOException {
        JsonArray result;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(URI.create("https://api.github.com/repos/%s/releases".formatted(this.githubRepo)).toURL().openStream(), StandardCharsets.UTF_8));){
            result = (JsonArray)Util.gson().fromJson((Reader)reader, JsonArray.class);
        }
        LinkedHashMap<String, String> versionMap = new LinkedHashMap<String, String>();
        for (JsonElement element : result) {
            versionMap.put(element.getAsJsonObject().get("tag_name").getAsString(), element.getAsJsonObject().get("html_url").getAsString());
        }
        return new Releases(new ArrayList<String>(versionMap.keySet()), versionMap);
    }

    private Distance fetchDistance(String branch, String hash) {
        Object object;
        URL url = URI.create("https://api.github.com/repos/%s/compare/%s...%s".formatted(this.githubRepo, branch, hash)).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.connect();
        if (connection.getResponseCode() == 404) {
            return new Distance.UnknownCommit();
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));
        try {
            JsonObject response = (JsonObject)Util.gson().fromJson((Reader)reader, JsonObject.class);
            String status = response.get("status").getAsString();
            object = switch (status) {
                case "identical" -> new Distance.UpToDate();
                case "behind" -> new Distance.Behind(response.get("behind_by").getAsInt());
                case "ahead" -> new Distance.Ahead();
                case "diverged" -> new Distance.Diverged();
                default -> new Distance.Failure(new IllegalArgumentException("Unknown status: '" + status + "'"));
            };
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException | NumberFormatException ex) {
                return new Distance.Failure((Exception)ex);
            }
        }
        reader.close();
        return object;
    }

    private static sealed interface Distance {

        public static final class Diverged
        implements Distance {
        }

        public static final class Ahead
        implements Distance {
        }

        public static final class UpToDate
        implements Distance {
        }

        public static final class UnknownCommit
        implements Distance {
        }

        public record Behind(int result) implements Distance
        {
        }

        public record Failure(Exception reason) implements Distance
        {
        }
    }

    private record Releases(List<String> releaseList, Map<String, String> releaseUrls) {
    }
}

