/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import net.minecraft.util.BitStorage;
import net.minecraft.util.Mth;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Heightmap;

final class HeightmapSnapshot {
    private final BitStorage data;
    private final LevelHeightAccessor heightAccessor;

    HeightmapSnapshot(ChunkAccess chunk, LevelHeightAccessor heightAccessor, Heightmap.Types heightmapType) {
        this.data = new SimpleBitStorage(Mth.ceillog2((int)(heightAccessor.getHeight() + 1)), 256, (long[])chunk.getOrCreateHeightmapUnprimed(heightmapType).getRawData().clone());
        this.heightAccessor = heightAccessor;
    }

    public int getFirstAvailable(int x, int z) {
        return this.getFirstAvailable(HeightmapSnapshot.getIndex(x, z));
    }

    private int getFirstAvailable(int index) {
        return this.data.get(index) + this.heightAccessor.getMinY();
    }

    private static int getIndex(int x, int z) {
        return x + z * 16;
    }
}

