/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import net.minecraft.core.BlockPos;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.api.MapWorld;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;

@DefaultQualifier(value=NonNull.class)
final class RectangleShape
implements VisibilityShape {
    private final int minBlockX;
    private final int maxBlockX;
    private final int minBlockZ;
    private final int maxBlockZ;
    private final int minChunkX;
    private final int maxChunkX;
    private final int minChunkZ;
    private final int maxChunkZ;
    private final int minRegionX;
    private final int maxRegionX;
    private final int minRegionZ;
    private final int maxRegionZ;

    RectangleShape(BlockPos min, BlockPos max) throws IllegalArgumentException {
        if (min.getX() > max.getX() || min.getZ() > max.getZ()) {
            throw new IllegalArgumentException("min > max: min=" + String.valueOf(min) + " max=" + String.valueOf(max));
        }
        this.minBlockX = min.getX();
        this.maxBlockX = max.getX();
        this.minBlockZ = min.getZ();
        this.maxBlockZ = max.getZ();
        this.minChunkX = Numbers.blockToChunk(this.minBlockX);
        this.maxChunkX = Numbers.blockToChunk(this.maxBlockX);
        this.minChunkZ = Numbers.blockToChunk(this.minBlockZ);
        this.maxChunkZ = Numbers.blockToChunk(this.maxBlockZ);
        this.minRegionX = Numbers.blockToRegion(this.minBlockX);
        this.maxRegionX = Numbers.blockToRegion(this.maxBlockX);
        this.minRegionZ = Numbers.blockToRegion(this.minBlockZ);
        this.maxRegionZ = Numbers.blockToRegion(this.maxBlockZ);
    }

    @Override
    public boolean shouldRenderChunk(MapWorld world, int chunkX, int chunkZ) {
        return chunkX >= this.minChunkX && chunkX <= this.maxChunkX && chunkZ >= this.minChunkZ && chunkZ <= this.maxChunkZ;
    }

    @Override
    public boolean shouldRenderRegion(MapWorld world, int regionX, int regionZ) {
        return regionX >= this.minRegionX && regionX <= this.maxRegionX && regionZ >= this.minRegionZ && regionZ <= this.maxRegionZ;
    }

    @Override
    public boolean shouldRenderColumn(MapWorld world, int blockX, int blockZ) {
        return blockX >= this.minBlockX && blockX <= this.maxBlockX && blockZ >= this.minBlockZ && blockZ <= this.maxBlockZ;
    }

    @Override
    public int countChunksInRegion(MapWorld world, int regionX, int regionZ) {
        int regionMinChunkX = Numbers.regionToChunk(regionX);
        int regionMaxChunkX = Numbers.regionToChunk(regionX + 1) - 1;
        int regionMinChunkZ = Numbers.regionToChunk(regionZ);
        int regionMaxChunkZ = Numbers.regionToChunk(regionZ + 1) - 1;
        int chunkWidth = Math.min(regionMaxChunkX, this.maxChunkX) - Math.max(regionMinChunkX, this.minChunkX) + 1;
        int chunkHeight = Math.min(regionMaxChunkZ, this.maxChunkZ) - Math.max(regionMinChunkZ, this.minChunkZ) + 1;
        if (chunkWidth < 0 || chunkHeight < 0) {
            return 0;
        }
        return chunkWidth * chunkHeight;
    }
}

