/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper;

import java.util.Objects;
import java.util.logging.Level;
import net.minecraft.server.level.ServerPlayer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Guice;
import squaremap.libraries.com.google.inject.Injector;
import xyz.jpenilla.squaremap.common.inject.SquaremapModulesBuilder;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.paper.PaperWorldManager;
import xyz.jpenilla.squaremap.paper.SquaremapPaper;
import xyz.jpenilla.squaremap.paper.data.PaperMapWorld;
import xyz.jpenilla.squaremap.paper.inject.module.PaperModule;
import xyz.jpenilla.squaremap.paper.util.PaperEntityScheduler;

@DefaultQualifier(value=NonNull.class)
public final class SquaremapPaperBootstrap
extends JavaPlugin {
    private static final String PAPER_DOWNLOADS_URL = "https://papermc.io/downloads";
    private static final String SQUAREMAP_RELEASES_URL = "https://github.com/jpenilla/squaremap/releases";
    private static final String TARGET_MINECRAFT_VERSION = Objects.requireNonNull(Objects.requireNonNull(Util.manifest(SquaremapPaperBootstrap.class), "Missing squaremap manifest").getMainAttributes().getValue("squaremap-target-minecraft-version"), "squaremap manifest missing 'squaremap-target-minecraft-version' attribute");
    private @Nullable SquaremapPaper squaremapPaper;

    public void onEnable() {
        if (!this.checkCompatibility()) {
            return;
        }
        Injector injector = Guice.createInjector(SquaremapModulesBuilder.forPlatform(SquaremapPaper.class).mapWorld(PaperMapWorld.class).worldManager(PaperWorldManager.class).entityScheduler(PaperEntityScheduler.class).withModule(new PaperModule(this)).build());
        this.squaremapPaper = injector.getInstance(SquaremapPaper.class);
        this.squaremapPaper.init();
    }

    public void onDisable() {
        if (this.squaremapPaper != null) {
            this.squaremapPaper.onDisable();
        }
    }

    private boolean checkCompatibility() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
        }
        catch (ClassNotFoundException ex) {
            return this.incompatible("squaremap requires a Paper-based server to run. Get Paper from https://papermc.io/downloads");
        }
        boolean mojangMapped = SquaremapPaperBootstrap.mojangMapped();
        if (!SquaremapPaperBootstrap.mappingsMatch()) {
            return this.incompatible("This squaremap jar is built using " + (mojangMapped ? "reobfuscated" : "Mojang") + " mappings,", "but the current server runtime is " + (mojangMapped ? "Mojang-mapped" : "reobfuscated") + ".", "Cannot proceed to load squaremap with mappings mismatch.");
        }
        if (!Bukkit.getMinecraftVersion().equals(TARGET_MINECRAFT_VERSION)) {
            if (mojangMapped) {
                this.logIncompatibilityMessage(Level.WARNING, "This squaremap jar is built for Minecraft " + TARGET_MINECRAFT_VERSION + ".", "It will attempt to load even though the current Minecraft version is " + Bukkit.getMinecraftVersion(), "as the environment is Mojang-mapped. This may or may not work, prefer running", "the correct squaremap version for your server. Check for newer or older releases", "which are intended for your Minecraft version at https://github.com/jpenilla/squaremap/releases.", "Keep in mind only the latest release of squaremap running on the intended Minecraft", "version is officially supported.");
                return true;
            }
            return this.incompatible("This squaremap jar is built for Minecraft " + TARGET_MINECRAFT_VERSION + ".", "It cannot run in the current environment (Minecraft " + Bukkit.getMinecraftVersion() + ").", "Check for newer or older releases which are compatible with your Minecraft version", "at https://github.com/jpenilla/squaremap/releases. Keep in mind only the latest release", "of squaremap is officially supported.");
        }
        return true;
    }

    private boolean incompatible(String ... messages) {
        this.logIncompatibilityMessage(Level.SEVERE, messages);
        this.getServer().getPluginManager().disablePlugin((Plugin)this);
        return false;
    }

    private void logIncompatibilityMessage(Level level, String ... messages) {
        StringBuilder builder = new StringBuilder("\n**********************************************\n");
        for (String msg : messages) {
            builder.append("** ").append(msg).append("\n");
        }
        builder.append("**********************************************\n");
        this.getLogger().log(level, builder.toString());
    }

    private static boolean mappingsMatch() {
        try {
            return ServerPlayer.class.getSimpleName() != null;
        }
        catch (NoClassDefFoundError err) {
            return false;
        }
    }

    private static boolean mojangMapped() {
        try {
            Class.forName("net.minecraft.server.level.ServerPlayer");
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }
}

