/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.bukkit.parser.location;

import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.org.incendo.cloud.bukkit.parser.location.LocationCoordinate;
import squaremap.libraries.org.incendo.cloud.bukkit.parser.location.LocationCoordinateType;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.context.CommandInput;
import squaremap.libraries.org.incendo.cloud.parser.ArgumentParseResult;
import squaremap.libraries.org.incendo.cloud.parser.ArgumentParser;
import squaremap.libraries.org.incendo.cloud.parser.standard.DoubleParser;

public final class LocationCoordinateParser<C>
implements ArgumentParser<C, LocationCoordinate> {
    @Override
    public @NonNull ArgumentParseResult<@NonNull LocationCoordinate> parse(@NonNull CommandContext<@NonNull C> commandContext, @NonNull CommandInput commandInput) {
        double coordinate;
        LocationCoordinateType locationCoordinateType;
        String input = commandInput.skipWhitespace().peekString();
        if (commandInput.peek() == '^') {
            locationCoordinateType = LocationCoordinateType.LOCAL;
            commandInput.moveCursor(1);
        } else if (commandInput.peek() == '~') {
            locationCoordinateType = LocationCoordinateType.RELATIVE;
            commandInput.moveCursor(1);
        } else {
            locationCoordinateType = LocationCoordinateType.ABSOLUTE;
        }
        try {
            boolean empty = commandInput.peekString().isEmpty() || commandInput.peek() == ' ';
            double d = coordinate = empty ? 0.0 : commandInput.readDouble();
            if (commandInput.hasRemainingInput()) {
                commandInput.skipWhitespace();
            }
        }
        catch (Exception e) {
            return ArgumentParseResult.failure(new DoubleParser.DoubleParseException(input, new DoubleParser(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY), commandContext));
        }
        return ArgumentParseResult.success(LocationCoordinate.of(locationCoordinateType, coordinate));
    }
}

