/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.processors.confirmation;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.execution.CommandExecutionHandler;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationContext;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationManager;

@API(status=API.Status.INTERNAL, since="1.0.0")
final class ConfirmationExecutionHandler<C>
implements CommandExecutionHandler.FutureCommandExecutionHandler<C> {
    private final ConfirmationManager<C> confirmationManager;

    ConfirmationExecutionHandler(@NonNull ConfirmationManager<C> confirmationManager) {
        this.confirmationManager = Objects.requireNonNull(confirmationManager, "confirmationManager");
    }

    @Override
    public @NonNull CompletableFuture<Void> executeFuture(@NonNull CommandContext<C> commandContext) {
        Optional<ConfirmationContext<C>> pending = this.confirmationManager.popPending(commandContext.sender());
        if (pending.isEmpty()) {
            this.confirmationManager.configuration().noPendingCommandNotifier().accept(commandContext.sender());
            return CompletableFuture.completedFuture(null);
        }
        return pending.get().command().commandExecutionHandler().executeFuture(pending.get().commandContext());
    }
}

