/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.processors.confirmation;

import java.time.Instant;
import java.util.Objects;
import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.org.incendo.cloud.execution.postprocessor.CommandPostprocessingContext;
import squaremap.libraries.org.incendo.cloud.execution.postprocessor.CommandPostprocessor;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationContext;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationManager;
import squaremap.libraries.org.incendo.cloud.services.type.ConsumerService;

@API(status=API.Status.INTERNAL, since="1.0.0")
final class ConfirmationPostprocessor<C>
implements CommandPostprocessor<C> {
    private final ConfirmationManager<C> confirmationManager;

    ConfirmationPostprocessor(@NonNull ConfirmationManager<C> confirmationManager) {
        this.confirmationManager = Objects.requireNonNull(confirmationManager, "confirmationManager");
    }

    @Override
    public void accept(@NonNull CommandPostprocessingContext<C> context) {
        if (!context.command().commandMeta().getOrDefault(ConfirmationManager.META_CONFIRMATION_REQUIRED, Boolean.valueOf(false)).booleanValue()) {
            return;
        }
        if (this.confirmationManager.configuration().bypassConfirmation().test(context.commandContext())) {
            return;
        }
        ConfirmationContext<C> confirmationContext = ConfirmationContext.of(Instant.now(), context.command(), context.commandContext());
        this.confirmationManager.addPending(context.commandContext().sender(), confirmationContext);
        this.confirmationManager.configuration().confirmationRequiredNotifier().accept(context.commandContext().sender(), confirmationContext);
        ConsumerService.interrupt();
    }
}

