/*
 * Decompiled with CFR 0.152.
 */
package squaremap.libraries.org.incendo.cloud.type.range;

import org.apiguardian.api.API;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.org.incendo.cloud.type.range.ByteRange;
import squaremap.libraries.org.incendo.cloud.type.range.ByteRangeImpl;
import squaremap.libraries.org.incendo.cloud.type.range.DoubleRange;
import squaremap.libraries.org.incendo.cloud.type.range.DoubleRangeImpl;
import squaremap.libraries.org.incendo.cloud.type.range.FloatRange;
import squaremap.libraries.org.incendo.cloud.type.range.FloatRangeImpl;
import squaremap.libraries.org.incendo.cloud.type.range.IntRange;
import squaremap.libraries.org.incendo.cloud.type.range.IntRangeImpl;
import squaremap.libraries.org.incendo.cloud.type.range.LongRange;
import squaremap.libraries.org.incendo.cloud.type.range.LongRangeImpl;
import squaremap.libraries.org.incendo.cloud.type.range.ShortRange;
import squaremap.libraries.org.incendo.cloud.type.range.ShortRangeImpl;

@API(status=API.Status.STABLE)
public interface Range<N extends Number> {
    public @NonNull N min();

    public @NonNull N max();

    public static @NonNull ByteRange byteRange(byte min, byte max) {
        return ByteRangeImpl.of(min, max);
    }

    public static @NonNull DoubleRange doubleRange(double min, double max) {
        return DoubleRangeImpl.of(min, max);
    }

    public static @NonNull FloatRange floatRange(float min, float max) {
        return FloatRangeImpl.of(min, max);
    }

    public static @NonNull IntRange intRange(int min, int max) {
        return IntRangeImpl.of(min, max);
    }

    public static @NonNull LongRange longRange(long min, long max) {
        return LongRangeImpl.of(min, max);
    }

    public static @NonNull ShortRange shortRange(short min, short max) {
        return ShortRangeImpl.of(min, max);
    }
}

