/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.argument.parser;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.util.ComponentMessageThrowable;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.context.CommandInput;
import squaremap.libraries.org.incendo.cloud.parser.ArgumentParseResult;
import squaremap.libraries.org.incendo.cloud.parser.ArgumentParser;
import squaremap.libraries.org.incendo.cloud.parser.ParserDescriptor;
import squaremap.libraries.org.incendo.cloud.suggestion.BlockingSuggestionProvider;
import xyz.jpenilla.squaremap.api.WorldIdentifier;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.config.WorldConfig;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class MapWorldParser<C>
implements ArgumentParser<C, MapWorldInternal>,
BlockingSuggestionProvider.Strings<C> {
    public static <C> ParserDescriptor<C, MapWorldInternal> mapWorldParser() {
        return ParserDescriptor.of(new MapWorldParser<C>(), MapWorldInternal.class);
    }

    @Override
    public ArgumentParseResult<MapWorldInternal> parse(CommandContext<C> commandContext, CommandInput commandInput) {
        String input = commandInput.readString();
        @Nullable Identifier key = Identifier.tryParse((String)input);
        if (key == null || key.getPath().isEmpty()) {
            return ArgumentParseResult.failure(new MapWorldParseException(input, MapWorldParseException.FailureReason.NO_SUCH_WORLD));
        }
        @Nullable ServerLevel world = commandContext.get(Commands.SERVER_ACCESS).level(Util.worldIdentifier(key));
        if (world == null) {
            return ArgumentParseResult.failure(new MapWorldParseException(input, MapWorldParseException.FailureReason.NO_SUCH_WORLD));
        }
        WorldConfig worldConfig = commandContext.get(Commands.CONFIG_MANAGER).worldConfig(world);
        if (!worldConfig.MAP_ENABLED) {
            return ArgumentParseResult.failure(new MapWorldParseException(input, MapWorldParseException.FailureReason.MAP_NOT_ENABLED));
        }
        return ArgumentParseResult.success(commandContext.get(Commands.WORLD_MANAGER).getWorldIfEnabled(world).orElseThrow());
    }

    public List<String> stringSuggestions(CommandContext<C> commandContext, CommandInput commandInput) {
        return commandContext.get(Commands.WORLD_MANAGER).worlds().stream().flatMap((? super T mapWorld) -> {
            WorldIdentifier identifier = mapWorld.identifier();
            if (!commandInput.remainingInput().isBlank() && identifier.namespace().equals("minecraft")) {
                return Stream.of(identifier.value(), identifier.asString());
            }
            return Stream.of(identifier.asString());
        }).toList();
    }

    public static final class MapWorldParseException
    extends IllegalArgumentException
    implements ComponentMessageThrowable {
        private final String input;
        private final FailureReason reason;

        public MapWorldParseException(String input, FailureReason reason) {
            this.input = input;
            this.reason = reason;
        }

        public Component componentMessage() {
            return this.reason.failureMessage.get().withPlaceholders(new TagResolver[]{Components.placeholder("world", this.input)});
        }

        @Override
        public String getMessage() {
            return PlainTextComponentSerializer.plainText().serialize(this.componentMessage());
        }

        public static enum FailureReason {
            NO_SUCH_WORLD(() -> Messages.NO_SUCH_WORLD),
            MAP_NOT_ENABLED(() -> Messages.MAP_NOT_ENABLED_FOR_WORLD);

            private final Supplier<Messages.ComponentMessage> failureMessage;

            private FailureReason(Supplier<Messages.ComponentMessage> failureMessage) {
                this.failureMessage = failureMessage;
            }
        }
    }
}

