/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.description.Description;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.parser.MapWorldParser;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.CommandUtil;
import xyz.jpenilla.squaremap.common.util.Components;

@DefaultQualifier(value=NonNull.class)
public final class CancelRenderCommand
extends SquaremapCommand {
    @Inject
    private CancelRenderCommand(Commands commands) {
        super(commands);
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("cancelrender", new String[0]).optional("world", MapWorldParser.mapWorldParser(), (Description)RichDescription.richDescription(Messages.OPTIONAL_WORLD_ARGUMENT_DESCRIPTION)).commandDescription(RichDescription.richDescription(Messages.CANCEL_RENDER_COMMAND_DESCRIPTION)).permission("squaremap.command.cancelrender").handler(this::executeCancelRender));
    }

    private void executeCancelRender(CommandContext<Commander> context) {
        Commander sender = context.sender();
        MapWorldInternal world = CommandUtil.resolveWorld(context);
        if (!world.renderManager().isRendering()) {
            sender.sendMessage(Messages.RENDER_NOT_IN_PROGRESS.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
            return;
        }
        sender.sendMessage(Messages.CANCELLED_RENDER.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
        world.renderManager().cancelRender();
    }
}

