/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import squaremap.libraries.org.incendo.cloud.processors.cache.SimpleCache;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationManager;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.util.Components;

@DefaultQualifier(value=NonNull.class)
public final class ConfirmCommand
extends SquaremapCommand {
    private final ConfirmationManager<Commander> confirmationManager = ConfirmationManager.confirmationManager(builder -> builder.cache(SimpleCache.of().keyExtractingView(Commander::commanderId)).noPendingCommandNotifier(sender -> sender.sendMessage(Messages.NO_PENDING_COMMANDS_MESSAGE)).confirmationRequiredNotifier((sender, ctx) -> sender.sendMessage(ConfirmCommand.confirmationRequiredMessage())).expiration(Duration.ofSeconds(15L)));

    private static ComponentLike confirmationRequiredMessage() {
        return ((TextComponent.Builder)((TextComponent.Builder)Component.text().append(Messages.CONFIRMATION_REQUIRED_MESSAGE.withPlaceholders(new TagResolver[]{Components.placeholder("command", Config.MAIN_COMMAND_LABEL)}))).hoverEvent((HoverEventSource)Messages.CLICK_TO_CONFIRM.asComponent())).clickEvent(ClickEvent.runCommand((String)("/" + Config.MAIN_COMMAND_LABEL + " confirm")));
    }

    @Inject
    private ConfirmCommand(Commands commands) {
        super(commands);
    }

    @Override
    public void register() {
        this.commands.commandManager().registerCommandPostProcessor(this.confirmationManager.createPostprocessor());
        this.commands.registerSubcommand(builder -> builder.literal("confirm", new String[0]).commandDescription(RichDescription.richDescription(Messages.CONFIRM_COMMAND_DESCRIPTION)).handler(this.confirmationManager.createExecutionHandler()));
    }
}

