/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.command.commands;

import java.io.IOException;
import java.nio.file.Path;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.minecraft.server.level.ServerLevel;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.Inject;
import squaremap.libraries.org.incendo.cloud.context.CommandContext;
import squaremap.libraries.org.incendo.cloud.minecraft.extras.RichDescription;
import squaremap.libraries.org.incendo.cloud.processors.confirmation.ConfirmationManager;
import xyz.jpenilla.squaremap.common.WorldManager;
import xyz.jpenilla.squaremap.common.command.Commander;
import xyz.jpenilla.squaremap.common.command.Commands;
import xyz.jpenilla.squaremap.common.command.SquaremapCommand;
import xyz.jpenilla.squaremap.common.command.argument.parser.LevelParser;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.util.Components;
import xyz.jpenilla.squaremap.common.util.FileUtil;

@DefaultQualifier(value=NonNull.class)
public final class ResetMapCommand
extends SquaremapCommand {
    private final DirectoryProvider directoryProvider;
    private final WorldManager worldManager;

    @Inject
    private ResetMapCommand(Commands commands, DirectoryProvider directoryProvider, WorldManager worldManager) {
        super(commands);
        this.directoryProvider = directoryProvider;
        this.worldManager = worldManager;
    }

    @Override
    public void register() {
        this.commands.registerSubcommand(builder -> builder.literal("resetmap", new String[0]).required("world", LevelParser.levelParser()).commandDescription(RichDescription.richDescription(Messages.RESETMAP_COMMAND_DESCRIPTION)).meta(ConfirmationManager.META_CONFIRMATION_REQUIRED, true).permission("squaremap.command.resetmap").handler(this::executeResetMap));
    }

    private void executeResetMap(CommandContext<Commander> context) {
        Commander sender = context.sender();
        ServerLevel world = (ServerLevel)context.get("world");
        Path worldTilesDir = this.directoryProvider.getAndCreateTilesDirectory(world);
        try {
            FileUtil.deleteContentsRecursively(worldTilesDir);
        }
        catch (IOException ex) {
            throw new RuntimeException("Could not reset map for level '" + String.valueOf(world.dimension().identifier()) + "'", ex);
        }
        this.worldManager.getWorldIfEnabled(world).ifPresent(MapWorldInternal::didReset);
        sender.sendMessage(Messages.SUCCESSFULLY_RESET_MAP.withPlaceholders(new TagResolver[]{Components.worldPlaceholder(world)}));
    }
}

