/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.config;

import java.util.List;
import java.util.Map;
import squaremap.libraries.org.spongepowered.configurate.NodePath;
import squaremap.libraries.org.spongepowered.configurate.transformation.ConfigurationTransformation;
import xyz.jpenilla.squaremap.common.config.AbstractConfig;
import xyz.jpenilla.squaremap.common.config.Transformations;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.util.ReflectionUtil;

public final class Advanced
extends AbstractConfig {
    private static final int LATEST_VERSION = 4;
    static Advanced config;

    Advanced(DirectoryProvider directoryProvider) {
        super(directoryProvider.dataDirectory(), Advanced.class, "advanced.yml", 4);
    }

    @Override
    protected void addVersions(ConfigurationTransformation.VersionedBuilder versionedBuilder) {
        NodePath defaultColorOverridesPath = NodePath.path("world-settings", "default", "color-overrides");
        ConfigurationTransformation oneToTwo = ConfigurationTransformation.builder().addAction(defaultColorOverridesPath.withAppendedChild("biomes").withAppendedChild("foliage"), Transformations.modifyStringMap(map -> map.put("minecraft:mangrove_swamp", "#6f9623"))).addAction(defaultColorOverridesPath.withAppendedChild("blocks"), Transformations.modifyStringMap(map -> map.put("minecraft:pink_petals", "#FFB4DB"))).build();
        ConfigurationTransformation twoToThree = ConfigurationTransformation.builder().addAction(NodePath.path("world-settings"), Transformations.eachMapChild(worldSection -> Transformations.applyMapKeyOrListValueRenames(List.of(worldSection.node("invisible-blocks"), worldSection.node("iterate-up-base-blocks"), worldSection.node("color-overrides", "blocks")), Map.of(Transformations.maybeMinecraft("grass"), "minecraft:short_grass")))).build();
        ConfigurationTransformation threeToFour = ConfigurationTransformation.builder().addAction(defaultColorOverridesPath.withAppendedChild("blocks"), Transformations.modifyStringMap(map -> map.put("minecraft:pale_oak_leaves", "#626760"))).build();
        versionedBuilder.addVersion(2, oneToTwo);
        versionedBuilder.addVersion(3, twoToThree);
        versionedBuilder.addVersion(4, threeToFour);
    }

    public static void reload(DirectoryProvider directoryProvider) {
        Class<?> spongeAdvancedClass;
        config = new Advanced(directoryProvider);
        config.readConfig(Advanced.class, null);
        Class<?> bukkitAdvancedClass = ReflectionUtil.findClass("xyz.jpenilla.squaremap.paper.config.PaperAdvanced");
        if (bukkitAdvancedClass != null) {
            config.readConfig(bukkitAdvancedClass, null);
        }
        if ((spongeAdvancedClass = ReflectionUtil.findClass("xyz.jpenilla.squaremap.sponge.config.SpongeAdvanced")) != null) {
            config.readConfig(spongeAdvancedClass, null);
        }
    }

    public static Advanced config() {
        return config;
    }
}

