/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.task.render;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.api.Pair;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.config.Config;
import xyz.jpenilla.squaremap.common.config.Messages;
import xyz.jpenilla.squaremap.common.task.render.AbstractRender;

@DefaultQualifier(value=NonNull.class)
public final class RenderProgress
extends TimerTask {
    private static final int ROLLING_AVG_SIZE = 20;
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("0.00%");
    private static final DecimalFormat RATE_FORMAT = new DecimalFormat("0.0");
    private final AbstractRender render;
    private final long startTime;
    private final int[] rollingAvgCps = new int[20];
    private final IntList totalAvgCps = new IntArrayList();
    private int rollingAvgIndex = 0;
    private int prevChunks;
    private long seconds;

    private RenderProgress(AbstractRender render, @Nullable RenderProgress old) {
        this.render = render;
        this.prevChunks = this.render.processedChunks();
        if (old != null) {
            this.startTime = old.startTime;
            this.rollingAvgIndex = old.rollingAvgIndex;
            this.seconds = old.seconds;
            this.totalAvgCps.addAll(old.totalAvgCps);
            System.arraycopy(old.rollingAvgCps, 0, this.rollingAvgCps, 0, this.rollingAvgCps.length);
        } else {
            this.startTime = System.currentTimeMillis();
        }
    }

    public static @Nullable Pair<Timer, RenderProgress> printProgress(AbstractRender render) {
        return RenderProgress.printProgress(render, null);
    }

    public static @Nullable Pair<Timer, RenderProgress> printProgress(AbstractRender render, @Nullable RenderProgress old) {
        if (!Config.PROGRESS_LOGGING) {
            return null;
        }
        Timer timer = new Timer("squaremap-render-progresslogger-[" + String.valueOf(render.level.dimension().identifier()) + "]");
        RenderProgress renderProgress = new RenderProgress(render, old);
        timer.scheduleAtFixedRate((TimerTask)renderProgress, 1000L, 1000L);
        return Pair.of(timer, renderProgress);
    }

    @Override
    public void run() {
        if (this.render.mapWorld.renderManager().rendersPaused()) {
            return;
        }
        int curChunks = this.render.processedChunks();
        int diff = curChunks - this.prevChunks;
        this.prevChunks = curChunks;
        this.rollingAvgCps[this.rollingAvgIndex] = diff;
        this.totalAvgCps.add(diff);
        ++this.rollingAvgIndex;
        if (this.rollingAvgIndex == 20) {
            this.rollingAvgIndex = 0;
        }
        double rollingAvg = Arrays.stream(this.rollingAvgCps).filter(i -> i != 0).average().orElse(0.0);
        int chunksLeft = this.render.totalChunks() - curChunks;
        long timeLeft = (long)((double)chunksLeft / (this.totalAvgCps.intStream().filter(i -> i != 0).average().orElse(0.0) / 1000.0));
        String etaStr = RenderProgress.formatMilliseconds(timeLeft);
        String elapsedStr = RenderProgress.formatMilliseconds(System.currentTimeMillis() - this.startTime);
        double percent = (double)curChunks / (double)this.render.totalChunks();
        String rateStr = RATE_FORMAT.format(rollingAvg);
        String percentStr = PERCENT_FORMAT.format(percent);
        int curRegions = this.render.processedRegions();
        int totalRegions = this.render.totalRegions();
        if (this.seconds % (long)Config.PROGRESS_LOGGING_INTERVAL != 0L) {
            ++this.seconds;
            return;
        }
        ++this.seconds;
        Logging.info(totalRegions > 0 ? Messages.LOG_RENDER_PROGRESS_WITH_REGIONS : Messages.LOG_RENDER_PROGRESS, "world", this.render.mapWorld.identifier().asString(), "current_regions", curRegions, "total_regions", totalRegions, "current_chunks", curChunks, "total_chunks", this.render.totalChunks(), "percent", percentStr, "elapsed", elapsedStr, "eta", etaStr, "rate", rateStr);
    }

    private static String formatMilliseconds(long timeLeft) {
        int hrs = (int)TimeUnit.MILLISECONDS.toHours(timeLeft) % 24;
        int min = (int)TimeUnit.MILLISECONDS.toMinutes(timeLeft) % 60;
        int sec = (int)TimeUnit.MILLISECONDS.toSeconds(timeLeft) % 60;
        return String.format("%02d:%02d:%02d", hrs, min, sec);
    }
}

