/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.Logging;
import xyz.jpenilla.squaremap.common.util.CheckedConsumer;
import xyz.jpenilla.squaremap.common.util.Util;

@DefaultQualifier(value=NonNull.class)
public final class FileUtil {
    private FileUtil() {
    }

    public static void deleteContentsRecursively(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> files = Files.list(directory);){
            files.forEach(Util.sneaky(FileUtil::deleteRecursively));
        }
    }

    public static void deleteRecursively(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).forEach(Util.sneaky(Files::delete));
        }
    }

    public static void openJar(Path jar, CheckedConsumer<FileSystem, IOException> consumer) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(jar);){
            consumer.accept(fileSystem);
        }
    }

    public static void specialCopyRecursively(Path from, Path to, boolean replaceExisting) throws IOException {
        if (!Files.exists(from, new LinkOption[0])) {
            return;
        }
        if (!Files.exists(to, new LinkOption[0])) {
            Files.createDirectories(to, new FileAttribute[0]);
        }
        try (Stream<Path> stream = Files.walk(from, new FileVisitOption[0]);){
            stream.forEach(Util.sneaky(path -> {
                Path target = to.resolve(FileUtil.invariantSeparatorsPathString(from.relativize((Path)path)));
                if (Files.isDirectory(path, new LinkOption[0])) {
                    if (Files.isDirectory(target, new LinkOption[0])) {
                        return;
                    }
                    if (Files.exists(target, new LinkOption[0])) {
                        if (replaceExisting) {
                            Files.delete(target);
                        } else {
                            return;
                        }
                    }
                    Files.createDirectories(target, new FileAttribute[0]);
                } else {
                    if (!replaceExisting && Files.exists(target, new LinkOption[0])) {
                        return;
                    }
                    if (replaceExisting && Files.isDirectory(target, new LinkOption[0])) {
                        FileUtil.deleteRecursively(target);
                    }
                    Files.copy(path, target, StandardCopyOption.REPLACE_EXISTING);
                }
            }));
        }
    }

    public static String invariantSeparatorsPathString(Path path) {
        String separator = path.getFileSystem().getSeparator();
        String pathString = path.toString();
        return separator.equals("/") ? pathString : pathString.replace(separator, "/");
    }

    public static void atomicWriteJsonAsync(Path file, Object object) {
        FileUtil.atomicWriteAsync(file, tmp -> {
            try (BufferedWriter writer = Files.newBufferedWriter(tmp, new OpenOption[0]);){
                Util.gson().toJson(object, (Appendable)writer);
            }
        });
    }

    public static void atomicWriteAsync(Path file, CheckedConsumer<Path, IOException> op) {
        ForkJoinPool.commonPool().execute(() -> {
            try {
                FileUtil.atomicWrite(file, op);
            }
            catch (IOException ex) {
                Logging.logger().warn("Failed to write file '{}'", (Object)file, (Object)ex);
            }
        });
    }

    public static void atomicWrite(Path path, CheckedConsumer<Path, IOException> op) throws IOException {
        Path tmp = FileUtil.siblingTempFile(path);
        try {
            op.accept(tmp);
            FileUtil.atomicMove(tmp, path, true);
        }
        catch (IOException ex) {
            try {
                Files.deleteIfExists(tmp);
            }
            catch (IOException ex1) {
                ex.addSuppressed(ex1);
            }
            throw ex;
        }
    }

    private static Path siblingTempFile(Path path) {
        return path.resolveSibling("." + System.nanoTime() + "-" + ThreadLocalRandom.current().nextInt() + "-" + path.getFileName().toString() + ".tmp");
    }

    public static void atomicMove(Path from, Path to, boolean replaceExisting) throws IOException {
        int maxRetries = 2;
        try {
            FileUtil.atomicMoveIfPossible(from, to, replaceExisting);
        }
        catch (AccessDeniedException ex) {
            int retries = 1;
            while (true) {
                try {
                    Thread.sleep(10L * (long)retries);
                    FileUtil.atomicMoveIfPossible(from, to, replaceExisting);
                    break;
                }
                catch (AccessDeniedException ex1) {
                    ex.addSuppressed(ex1);
                    if (retries == 2) {
                        throw ex;
                    }
                }
                catch (InterruptedException interruptedException) {
                    ex.addSuppressed(interruptedException);
                    Thread.currentThread().interrupt();
                    throw ex;
                }
                ++retries;
            }
        }
    }

    private static void atomicMoveIfPossible(Path from, Path to, boolean replaceExisting) throws IOException {
        CopyOption[] copyOptionArray;
        if (replaceExisting) {
            CopyOption[] copyOptionArray2 = new CopyOption[2];
            copyOptionArray2[0] = StandardCopyOption.ATOMIC_MOVE;
            copyOptionArray = copyOptionArray2;
            copyOptionArray2[1] = StandardCopyOption.REPLACE_EXISTING;
        } else {
            CopyOption[] copyOptionArray3 = new CopyOption[1];
            copyOptionArray = copyOptionArray3;
            copyOptionArray3[0] = StandardCopyOption.ATOMIC_MOVE;
        }
        CopyOption[] options = copyOptionArray;
        try {
            Files.move(from, to, options);
        }
        catch (AtomicMoveNotSupportedException ex) {
            CopyOption[] copyOptionArray4;
            if (replaceExisting) {
                CopyOption[] copyOptionArray5 = new CopyOption[1];
                copyOptionArray4 = copyOptionArray5;
                copyOptionArray5[0] = StandardCopyOption.REPLACE_EXISTING;
            } else {
                copyOptionArray4 = new CopyOption[]{};
            }
            Files.move(from, to, copyOptionArray4);
        }
    }
}

