/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.util.chunksnapshot;

import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.ChunkSnapshot;
import xyz.jpenilla.squaremap.common.util.chunksnapshot.HeightmapSnapshot;

@DefaultQualifier(value=NonNull.class)
record ChunkSnapshotImpl(LevelHeightAccessor heightAccessor, PalettedContainer<BlockState>[] states, PalettedContainer<Holder<Biome>>[] biomes, Map<Heightmap.Types, HeightmapSnapshot> heightmaps, boolean[] emptySections, DimensionType dimensionType, ChunkPos pos) implements ChunkSnapshot
{
    static final EnumMap<Heightmap.Types, HeightmapSnapshot> EMPTY_HEIGHTMAPS = new EnumMap(Heightmap.Types.class);

    @Override
    public BlockState getBlockState(BlockPos pos) {
        return this.getBlockState(pos.getX(), pos.getY(), pos.getZ());
    }

    private BlockState getBlockState(int x, int y, int z) {
        int sectionIndex = this.getSectionIndex(y);
        if (sectionIndex < 0 || sectionIndex >= this.states.length || this.sectionEmpty(sectionIndex)) {
            return Blocks.AIR.defaultBlockState();
        }
        return (BlockState)this.states[sectionIndex].get((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF);
    }

    @Override
    public FluidState getFluidState(BlockPos pos) {
        return this.getFluidState(pos.getX(), pos.getY(), pos.getZ());
    }

    private FluidState getFluidState(int x, int y, int z) {
        int sectionIndex = this.getSectionIndex(y);
        if (sectionIndex < 0 || sectionIndex >= this.states.length || this.sectionEmpty(sectionIndex)) {
            return Fluids.EMPTY.defaultFluidState();
        }
        return ((BlockState)this.states[sectionIndex].get((y & 0xF) << 8 | (z & 0xF) << 4 | x & 0xF)).getFluidState();
    }

    @Override
    public int getHeight(Heightmap.Types type, int x, int z) {
        HeightmapSnapshot heightmap = this.heightmaps.get(type);
        if (heightmap == null) {
            throw new RuntimeException("Missing heightmaps " + String.valueOf(type));
        }
        return heightmap.getFirstAvailable(x & 0xF, z & 0xF) - 1;
    }

    public int getHeight() {
        return this.heightAccessor.getHeight();
    }

    public int getMinY() {
        return this.heightAccessor.getMinY();
    }

    @Override
    public boolean sectionEmpty(int sectionIndex) {
        return this.emptySections[sectionIndex];
    }

    public Holder<Biome> getNoiseBiome(int quartX, int quartY, int quartZ) {
        int minQuartY = QuartPos.fromBlock((int)this.getMinY());
        int maxQuartY = minQuartY + QuartPos.fromBlock((int)this.getHeight()) - 1;
        int clampedQuartY = Mth.clamp((int)quartY, (int)minQuartY, (int)maxQuartY);
        int sectionIndex = this.getSectionIndex(QuartPos.toBlock((int)clampedQuartY));
        return (Holder)this.biomes[sectionIndex].get(quartX & 3, clampedQuartY & 3, quartZ & 3);
    }
}

