/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.common.visibilitylimit;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import org.checkerframework.checker.nullness.qual.Nullable;
import squaremap.libraries.org.spongepowered.configurate.ConfigurationNode;
import squaremap.libraries.org.spongepowered.configurate.serialize.SerializationException;
import squaremap.libraries.org.spongepowered.configurate.serialize.TypeSerializer;
import xyz.jpenilla.squaremap.api.Point;
import xyz.jpenilla.squaremap.common.visibilitylimit.CircleShape;
import xyz.jpenilla.squaremap.common.visibilitylimit.PolygonShape;
import xyz.jpenilla.squaremap.common.visibilitylimit.RectangleShape;
import xyz.jpenilla.squaremap.common.visibilitylimit.VisibilityShape;
import xyz.jpenilla.squaremap.common.visibilitylimit.WorldBorderShape;

public final class VisibilityShapeSerializer
implements TypeSerializer<VisibilityShape> {
    @Override
    public VisibilityShape deserialize(Type type, ConfigurationNode node) throws SerializationException {
        String typeString = node.node("type").getString();
        if (typeString == null) {
            throw new SerializationException(node.node("type"), (Type)((Object)String.class), "Missing type for visibility shape");
        }
        @Nullable String enabled = node.node("enabled").getString();
        if (enabled != null && !Boolean.parseBoolean(enabled)) {
            return VisibilityShape.NULL;
        }
        return switch (typeString) {
            case "circle" -> this.parseCircleShape(node);
            case "rectangle" -> this.parseRectangleShape(node);
            case "polygon" -> this.parsePolygonShape(node);
            case "world-border" -> new WorldBorderShape();
            default -> throw new SerializationException(node.node("type"), (Type)((Object)String.class), "Unknown shape type '" + typeString + "'");
        };
    }

    private VisibilityShape parseCircleShape(ConfigurationNode visibilityLimit) {
        int centerX = visibilityLimit.node("center-x").getInt();
        int centerZ = visibilityLimit.node("center-z").getInt();
        int radius = visibilityLimit.node("radius").getInt();
        if (radius > 0) {
            return new CircleShape(centerX, centerZ, radius);
        }
        return null;
    }

    private VisibilityShape parseRectangleShape(ConfigurationNode visibilityLimit) {
        int minX = visibilityLimit.node("min-x").getInt();
        int minZ = visibilityLimit.node("min-z").getInt();
        int maxX = visibilityLimit.node("max-x").getInt();
        int maxZ = visibilityLimit.node("max-z").getInt();
        if (maxX >= minX && maxZ >= minZ) {
            return new RectangleShape(new BlockPos(minX, 0, minZ), new BlockPos(maxX, 0, maxZ));
        }
        return null;
    }

    private VisibilityShape parsePolygonShape(ConfigurationNode visibilityLimit) throws SerializationException {
        List<String> pointStrings = visibilityLimit.node("points").getList(String.class);
        if (pointStrings == null) {
            throw new SerializationException("Missing point list");
        }
        return new PolygonShape(pointStrings.stream().map(s -> {
            int[] ints = Arrays.stream(s.split("[, ]")).filter(Predicate.not(String::isBlank)).mapToInt(Integer::parseInt).toArray();
            return Point.of(ints[0], ints[1]);
        }).toList());
    }

    @Override
    public void serialize(Type type, @Nullable VisibilityShape obj, ConfigurationNode node) throws SerializationException {
        if (obj == null) {
            node.raw(null);
            return;
        }
        if (obj instanceof WorldBorderShape) {
            node.node("type").set("world-border");
            node.node("enabled").set("false");
            return;
        }
        throw new UnsupportedOperationException();
    }
}

