/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.data;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import squaremap.libraries.com.google.inject.assistedinject.Assisted;
import squaremap.libraries.com.google.inject.assistedinject.AssistedInject;
import xyz.jpenilla.squaremap.common.config.ConfigManager;
import xyz.jpenilla.squaremap.common.data.DirectoryProvider;
import xyz.jpenilla.squaremap.common.data.MapWorldInternal;
import xyz.jpenilla.squaremap.common.task.TaskFactory;
import xyz.jpenilla.squaremap.common.task.render.RenderFactory;
import xyz.jpenilla.squaremap.common.util.ExceptionLoggingScheduledThreadPoolExecutor;
import xyz.jpenilla.squaremap.common.util.Util;
import xyz.jpenilla.squaremap.paper.util.Folia;

@DefaultQualifier(value=NonNull.class)
public final class PaperMapWorld
extends MapWorldInternal {
    private final MarkerTaskHandler markerTaskHandler;

    @AssistedInject
    private PaperMapWorld(@Assisted ServerLevel level, JavaPlugin plugin, RenderFactory renderFactory, DirectoryProvider directoryProvider, Server server, ConfigManager configManager, TaskFactory taskFactory) {
        super(level, renderFactory, directoryProvider, configManager);
        this.markerTaskHandler = Folia.FOLIA ? new FoliaMarkerTaskHandler(this, level, taskFactory) : new PaperMarkerTaskHandler(this, plugin, server, taskFactory);
    }

    @Override
    public BlockPos getSpawnPos() {
        return this.serverLevel().serverLevelData.getRespawnData().pos();
    }

    @Override
    public void shutdown() {
        this.markerTaskHandler.shutdown();
        super.shutdown();
    }

    private final class FoliaMarkerTaskHandler
    implements MarkerTaskHandler {
        private final ScheduledExecutorService markerThread;
        private final ScheduledFuture<?> updateMarkersTask;

        private FoliaMarkerTaskHandler(PaperMapWorld paperMapWorld, ServerLevel level, TaskFactory taskFactory) {
            this.markerThread = new ExceptionLoggingScheduledThreadPoolExecutor(1, Util.squaremapThreadFactory("markers", level));
            this.updateMarkersTask = this.markerThread.scheduleAtFixedRate(taskFactory.createUpdateMarkers(paperMapWorld), 5L, paperMapWorld.config().MARKER_API_UPDATE_INTERVAL_SECONDS, TimeUnit.SECONDS);
        }

        @Override
        public void shutdown() {
            this.updateMarkersTask.cancel(false);
            Util.shutdownExecutor(this.markerThread, TimeUnit.MILLISECONDS, 100L);
        }
    }

    private static interface MarkerTaskHandler {
        public void shutdown();
    }

    private final class PaperMarkerTaskHandler
    implements MarkerTaskHandler {
        private final BukkitTask updateMarkersTask;

        private PaperMarkerTaskHandler(PaperMapWorld paperMapWorld, JavaPlugin plugin, Server server, TaskFactory taskFactory) {
            this.updateMarkersTask = server.getScheduler().runTaskTimer((Plugin)plugin, (Runnable)taskFactory.createUpdateMarkers(paperMapWorld), 100L, 20L * (long)paperMapWorld.config().MARKER_API_UPDATE_INTERVAL_SECONDS);
        }

        @Override
        public void shutdown() {
            this.updateMarkersTask.cancel();
        }
    }
}

