/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.squaremap.paper.listener;

import io.papermc.paper.event.packet.PlayerChunkLoadEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockFadeEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockFromToEvent;
import org.bukkit.event.block.BlockGrowEvent;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.BlockSpreadEvent;
import org.bukkit.event.block.EntityBlockFormEvent;
import org.bukkit.event.block.FluidLevelChangeEvent;
import org.bukkit.event.block.LeavesDecayEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkPopulateEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.checkerframework.checker.nullness.qual.NonNull;
import squaremap.libraries.com.google.inject.Inject;
import xyz.jpenilla.squaremap.common.data.ChunkCoordinate;
import xyz.jpenilla.squaremap.common.util.Numbers;
import xyz.jpenilla.squaremap.paper.PaperWorldManager;
import xyz.jpenilla.squaremap.paper.config.PaperAdvanced;

public final class MapUpdateListeners {
    private final JavaPlugin plugin;
    private final PaperWorldManager worldManager;
    private final List<Listener> registeredListeners = new ArrayList<Listener>();

    @Inject
    private MapUpdateListeners(@NonNull JavaPlugin plugin, @NonNull PaperWorldManager worldManager) {
        this.plugin = plugin;
        this.worldManager = worldManager;
    }

    public void register() {
        this.registerBlockEventListener(BlockPlaceEvent.class);
        this.registerBlockEventListener(BlockBreakEvent.class);
        this.registerBlockEventListener(LeavesDecayEvent.class);
        this.registerBlockEventListener(BlockBurnEvent.class);
        this.registerBlockEventListener(BlockExplodeEvent.class);
        this.registerBlockEventListener(BlockGrowEvent.class);
        this.registerBlockEventListener(BlockFormEvent.class);
        this.registerBlockEventListener(BlockFadeEvent.class);
        this.registerBlockEventListener(EntityBlockFormEvent.class);
        this.registerBlockEventListener(BlockSpreadEvent.class);
        this.registerBlockEventListener(BlockPhysicsEvent.class);
        this.registerPlayerEventListener(PlayerMoveEvent.class);
        this.registerPlayerEventListener(PlayerJoinEvent.class);
        this.registerPlayerEventListener(PlayerQuitEvent.class);
        this.registerListener(BlockPistonExtendEvent.class, this::handleBlockPistonExtendEvent);
        this.registerListener(BlockPistonRetractEvent.class, this::handleBlockPistonRetractEvent);
        this.registerListener(FluidLevelChangeEvent.class, this::handleFluidLevelChangeEvent);
        this.registerListener(BlockFromToEvent.class, this::handleBlockFromToEvent);
        this.registerListener(EntityExplodeEvent.class, this::handleEntityExplodeEvent);
        this.registerListener(EntityChangeBlockEvent.class, this::handleEntityChangeBlockEvent);
        this.registerListener(StructureGrowEvent.class, this::handleStructureGrowEvent);
        this.registerListener(ChunkPopulateEvent.class, this::handleChunkPopulateEvent);
        this.registerListener(ChunkLoadEvent.class, this::handleChunkLoadEvent);
        this.registerListener(PlayerChunkLoadEvent.class, this::handlePlayerChunkLoadEvent);
    }

    public void unregister() {
        this.registeredListeners.forEach(HandlerList::unregisterAll);
        this.registeredListeners.clear();
    }

    private <E extends Event> void registerListener(@NonNull Class<E> eventClass, @NonNull Consumer<E> eventConsumer) {
        if (!PaperAdvanced.listenerEnabled(eventClass)) {
            return;
        }
        Listener listener = new Listener(this){};
        this.registeredListeners.add(listener);
        Bukkit.getPluginManager().registerEvent(eventClass, listener, EventPriority.MONITOR, (l, event) -> {
            if (!eventClass.isAssignableFrom(event.getClass())) {
                return;
            }
            eventConsumer.accept((Event)eventClass.cast(event));
        }, (Plugin)this.plugin, true);
    }

    private <B extends BlockEvent> void registerBlockEventListener(@NonNull Class<B> eventClass) {
        this.registerListener(eventClass, this::handleBlockEvent);
    }

    private <P extends PlayerEvent> void registerPlayerEventListener(@NonNull Class<P> eventClass) {
        this.registerListener(eventClass, this::handlePlayerEvent);
    }

    private void markChunk(@NonNull Location loc) {
        this.markChunk(loc, false);
    }

    private void markChunk(@NonNull Location loc, boolean skipVisibilityCheck) {
        this.worldManager.getWorldIfEnabled(loc.getWorld()).ifPresent(mapWorld -> {
            if (skipVisibilityCheck || MapUpdateListeners.locationVisible(loc)) {
                mapWorld.chunkModified(new ChunkCoordinate(Numbers.blockToChunk(loc.getBlockX()), Numbers.blockToChunk(loc.getBlockZ())));
            }
        });
    }

    private void markLocations(@NonNull World world, @NonNull List<Location> locations) {
        this.worldManager.getWorldIfEnabled(world).ifPresent(mapWorld -> locations.stream().filter(MapUpdateListeners::locationVisible).map(loc -> new ChunkCoordinate(Numbers.blockToChunk(loc.getBlockX()), Numbers.blockToChunk(loc.getBlockZ()))).distinct().forEach(mapWorld::chunkModified));
    }

    private void markChunksFromBlocks(@NonNull World world, @NonNull List<BlockState> blockStates) {
        this.worldManager.getWorldIfEnabled(world).ifPresent(mapWorld -> blockStates.stream().map(BlockState::getLocation).filter(MapUpdateListeners::locationVisible).map(loc -> new ChunkCoordinate(Numbers.blockToChunk(loc.getBlockX()), Numbers.blockToChunk(loc.getBlockZ()))).distinct().forEach(mapWorld::chunkModified));
    }

    private static boolean locationVisible(@NonNull Location loc) {
        if (loc.getWorld().hasCeiling()) {
            return true;
        }
        return loc.getY() >= (double)(loc.getWorld().getHighestBlockYAt(loc) - 10);
    }

    private void handleBlockPistonExtendEvent(@NonNull BlockPistonExtendEvent event) {
        this.markLocations(event.getBlock().getWorld(), event.getBlocks().stream().map(Block::getLocation).toList());
    }

    private void handleBlockPistonRetractEvent(@NonNull BlockPistonRetractEvent event) {
        this.markLocations(event.getBlock().getWorld(), event.getBlocks().stream().map(Block::getLocation).toList());
    }

    private void handleBlockEvent(@NonNull BlockEvent blockEvent) {
        this.markChunk(blockEvent.getBlock().getLocation());
    }

    private void handlePlayerEvent(@NonNull PlayerEvent playerEvent) {
        this.markChunk(playerEvent.getPlayer().getLocation(), true);
    }

    private void handleStructureGrowEvent(@NonNull StructureGrowEvent event) {
        this.markChunksFromBlocks(event.getWorld(), event.getBlocks());
    }

    private void handleBlockFromToEvent(@NonNull BlockFromToEvent event) {
        this.markChunk(event.getToBlock().getLocation(), true);
    }

    private void handleEntityChangeBlockEvent(@NonNull EntityChangeBlockEvent event) {
        this.markChunk(event.getBlock().getLocation());
    }

    private void handleEntityExplodeEvent(@NonNull EntityExplodeEvent event) {
        this.markChunksFromBlocks(event.getLocation().getWorld(), event.blockList().stream().map(Block::getState).toList());
    }

    private void handleFluidLevelChangeEvent(@NonNull FluidLevelChangeEvent event) {
        if (event.getBlock().getBlockData().getMaterial() != event.getNewData().getMaterial()) {
            this.handleBlockEvent((BlockEvent)event);
        }
    }

    private void handleChunkPopulateEvent(@NonNull ChunkPopulateEvent event) {
        Chunk chunk = event.getChunk();
        this.markChunk(new Location(chunk.getWorld(), (double)Numbers.chunkToBlock(chunk.getX()), 0.0, (double)Numbers.chunkToBlock(chunk.getZ())), true);
    }

    private void handleChunkLoadEvent(@NonNull ChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        this.markChunk(new Location(chunk.getWorld(), (double)Numbers.chunkToBlock(chunk.getX()), 0.0, (double)Numbers.chunkToBlock(chunk.getZ())), true);
    }

    private void handlePlayerChunkLoadEvent(@NonNull PlayerChunkLoadEvent event) {
        Chunk chunk = event.getChunk();
        this.markChunk(new Location(chunk.getWorld(), (double)Numbers.chunkToBlock(chunk.getX()), 0.0, (double)Numbers.chunkToBlock(chunk.getZ())), true);
    }
}

