/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.seaotter.mob.goals;

import aquariusplayz.animalgarden.seaotter.mob.ModMob;
import aquariusplayz.animalgarden.seaotter.setup.Registrations;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;

public class ModEatGoal
extends Goal {
    protected final ModMob mob;
    private double speedModifier;
    private final boolean followingTargetEvenIfNotSeen;
    private Path path;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    private final int attackInterval = 20;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;

    public ModEatGoal(ModMob p_25552_, double p_25553_, boolean p_25554_) {
        this.mob = p_25552_;
        this.speedModifier = p_25553_;
        this.followingTargetEvenIfNotSeen = p_25554_;
    }

    public boolean canUse() {
        if (this.mob.dontPlay > 0) {
            return false;
        }
        if (this.mob.getBehaviorType() > 2) {
            return false;
        }
        long i = this.mob.level().getGameTime();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.ticksUntilNextPathRecalculation <= 0) {
                this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.mob.getNavigation().createPath((Entity)livingentity, 0);
        return this.path != null ? true : this.mob.isWithinMeleeAttackRange((Entity)livingentity);
    }

    public boolean canContinueToUse() {
        if (this.mob.dontPlay > 0) {
            return false;
        }
        if (!this.mob.targetFound) {
            return false;
        }
        if (this.mob.getBehaviorType() > 2) {
            return false;
        }
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.isAlive()) {
            return false;
        }
        if (!this.followingTargetEvenIfNotSeen) {
            return !this.mob.getNavigation().isDone();
        }
        return this.mob.isWithinRestriction(livingentity.blockPosition());
    }

    public void start() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        this.mob.getNavigation().moveTo(this.path, this.speedModifier);
        this.mob.setAggressive(true);
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
    }

    public void stop() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.mob.setTarget(null);
        }
        this.mob.setAggressive(false);
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        ItemEntity livingentity = this.mob.nearestItemEntity;
        if (livingentity != null) {
            this.mob.getLookControl().setLookAt((Entity)livingentity, 30.0f, 30.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if ((this.followingTargetEvenIfNotSeen || this.mob.getSensing().hasLineOfSight((Entity)livingentity)) && this.ticksUntilNextPathRecalculation <= 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || livingentity.distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = livingentity.getX();
                this.pathedTargetY = livingentity.getY();
                this.pathedTargetZ = livingentity.getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                double d0 = this.mob.distanceToSqr((Entity)livingentity);
                if (this.canPenalize) {
                    Node finalPathPoint;
                    this.ticksUntilNextPathRecalculation += this.failedPathFindingPenalty;
                    this.failedPathFindingPenalty = this.mob.getNavigation().getPath() != null ? ((finalPathPoint = this.mob.getNavigation().getPath().getEndNode()) != null && livingentity.distanceToSqr((double)finalPathPoint.x, (double)finalPathPoint.y, (double)finalPathPoint.z) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
                }
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.getNavigation().moveTo((Entity)livingentity, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.checkAndPerformAttack((Entity)livingentity);
        }
    }

    protected void checkAndPerformAttack(Entity p_25557_) {
        if (this.canPerformAttack(p_25557_) && this.mob.dontPlay == 0) {
            ItemStack itemstack;
            this.resetAttackCooldown();
            this.mob.swing(InteractionHand.MAIN_HAND);
            if (this.mob.nearestItemEntity != null && (itemstack = this.mob.nearestItemEntity.getItem()).is(Registrations.FOOD_ITEMS)) {
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                if (foodproperties != null) {
                    float f;
                    float f2 = f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                    if (this.mob.getHealth() < this.mob.getMaxHealth()) {
                        this.mob.heal(2.0f * f);
                    }
                }
                this.mob.playSound(SoundEvents.FOX_BITE, 1.0f, this.mob.getRandom().nextFloat() * 0.2f + 0.2f);
                this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)4);
                this.mob.nearestItemEntity.discard();
                this.mob.nearestItemEntity = null;
                this.mob.dontPlay = 100;
                this.mob.targetFound = false;
            }
        }
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(20);
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean canPerformAttack(Entity p_301160_) {
        return this.isTimeToAttack() && this.mob.isWithinMeleeAttackRange(p_301160_) && this.mob.getSensing().hasLineOfSight(p_301160_);
    }

    protected int getTicksUntilNextAttack() {
        return this.ticksUntilNextAttack;
    }

    protected int getAttackInterval() {
        return this.adjustedTickDelay(20);
    }
}

