/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.seaotter.mob.goals;

import aquariusplayz.animalgarden.seaotter.mob.ModMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModRandomSwimmingOrWalkingGoal
extends RandomStrollGoal {
    public static final float PROBABILITY = 0.001f;
    public final float probability;
    public ModMob mob;

    public ModRandomSwimmingOrWalkingGoal(PathfinderMob p_25987_, double p_25988_) {
        this(p_25987_, p_25988_, 0.001f);
        this.mob = (ModMob)p_25987_;
    }

    public ModRandomSwimmingOrWalkingGoal(PathfinderMob p_25990_, double p_25991_, float p_25992_) {
        super(p_25990_, p_25991_);
        this.probability = p_25992_;
        this.mob = (ModMob)p_25990_;
    }

    public boolean canUse() {
        if (this.mob.isPassenger()) {
            return false;
        }
        if (this.mob.leader != this.mob && this.mob.leader != null) {
            if (this.mob.distanceToSqr((Entity)this.mob.leader) >= ModMob.FOLLOW_LEADER_START_DISTANCE) {
                return false;
            }
        }
        if (this.mob.getBehaviorType() == 4) {
            return false;
        }
        if (this.mob.getBehaviorType() > 0 && this.mob.getBehaviorType() < 3 && this.mob.onGround()) {
            this.mob.setBehaviorType(0);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)5);
        }
        if (this.mob.getBehaviorType() < 3) {
            return super.canUse();
        }
        return false;
    }

    public void stop() {
    }

    public boolean canContinueToUse() {
        if (this.mob.getBehaviorType() == 4) {
            return false;
        }
        if (this.mob.getBehaviorType() > 0 && this.mob.getBehaviorType() < 3 && this.mob.onGround()) {
            this.mob.setBehaviorType(0);
            this.mob.level().broadcastEntityEvent((Entity)this.mob, (byte)5);
        }
        if (this.mob.getBehaviorType() < 3) {
            return super.canContinueToUse();
        }
        return false;
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.mob.isInWater()) {
            Vec3 vec3 = BehaviorUtils.getRandomSwimmablePos((PathfinderMob)this.mob, (int)10, (int)10);
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.mob.getRandom().nextFloat() >= this.probability ? LandRandomPos.getPos((PathfinderMob)this.mob, (int)15, (int)10) : super.getPosition();
    }
}

