/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.seaotter.mob;

import aquariusplayz.animalgarden.seaotter.mob.ModAnimationState;
import aquariusplayz.animalgarden.seaotter.mob.controls.ModBodyRotationControl;
import aquariusplayz.animalgarden.seaotter.mob.controls.ModMobPathNavigation;
import aquariusplayz.animalgarden.seaotter.mob.controls.ModSmoothSwimmingLookControl;
import aquariusplayz.animalgarden.seaotter.mob.controls.ModSmoothSwimmingMoveControl;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModBreedGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModEatGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModFollowLeaderGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModFollowOwnerGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModFollowParentGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModMeleeAttackGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModNearestAttackableFoodTargetGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModNearestAttackableTargetGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModOwnerHurtByTargetGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModOwnerHurtTargetGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModPanicGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModRandomSwimmingOrWalkingGoal;
import aquariusplayz.animalgarden.seaotter.mob.goals.ModTemptGoal;
import aquariusplayz.animalgarden.seaotter.setup.Registrations;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.AbstractSchoolingFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ModMob
extends TamableAnimal
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BEHAVIOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> FUR_COLOR = SynchedEntityData.defineId(ModMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.rangeOfSeconds((int)20, (int)39);
    @Nullable
    private UUID persistentAngerTarget;
    public final ModAnimationState makeSound = new ModAnimationState();
    public final ModAnimationState wink = new ModAnimationState();
    public final ModAnimationState tired = new ModAnimationState();
    public final ModAnimationState breathing = new ModAnimationState();
    public final ModAnimationState eat = new ModAnimationState();
    public final ModAnimationState sniffing = new ModAnimationState();
    public final ModAnimationState tail = new ModAnimationState();
    public final ModAnimationState panting = new ModAnimationState();
    public final ModAnimationState bite = new ModAnimationState();
    public final ModAnimationState eyeRubbing = new ModAnimationState();
    public final ModAnimationState earRubbing = new ModAnimationState();
    public final ModAnimationState eyeLookLeft = new ModAnimationState();
    public final ModAnimationState eyeLookRight = new ModAnimationState();
    public final ModAnimationState eyeLookUp = new ModAnimationState();
    public final ModAnimationState eyeLookDown = new ModAnimationState();
    public final ModAnimationState leftEyeBrowUp = new ModAnimationState();
    public final ModAnimationState leftEyeBrowDown = new ModAnimationState();
    public final ModAnimationState rightEyeBrowUp = new ModAnimationState();
    public final ModAnimationState rightEyeBrowDown = new ModAnimationState();
    public final ModAnimationState leftEyeBrowAngry = new ModAnimationState();
    public final ModAnimationState rightEyeBrowAngry = new ModAnimationState();
    public final ModAnimationState leftEyeBrowSad = new ModAnimationState();
    public final ModAnimationState rightEyeBrowSad = new ModAnimationState();
    public final ModAnimationState rightEar = new ModAnimationState();
    public final ModAnimationState rightEar2 = new ModAnimationState();
    public final ModAnimationState leftEar = new ModAnimationState();
    public final ModAnimationState leftEar2 = new ModAnimationState();
    public final ModAnimationState headLookLeft = new ModAnimationState();
    public final ModAnimationState headLookRight = new ModAnimationState();
    public final ModAnimationState headLookUp = new ModAnimationState();
    public final ModAnimationState headLookDown = new ModAnimationState();
    public final ModAnimationState headLookMoreLeft = new ModAnimationState();
    public final ModAnimationState headLookMoreRight = new ModAnimationState();
    public final ModAnimationState headLookMoreUp = new ModAnimationState();
    public final ModAnimationState headLookMoreDown = new ModAnimationState();
    public final ModAnimationState headTiltLeft = new ModAnimationState();
    public final ModAnimationState headTiltRight = new ModAnimationState();
    public final ModAnimationState headTiltMoreLeft = new ModAnimationState();
    public final ModAnimationState headTiltMoreRight = new ModAnimationState();
    public final ModAnimationState layOnBack = new ModAnimationState();
    public final ModAnimationState onBack = new ModAnimationState();
    public final ModAnimationState fromLayingOnBackToNormal = new ModAnimationState();
    public final ModAnimationState onSide = new ModAnimationState();
    public final ModAnimationState spinningOnLand = new ModAnimationState();
    public final ModAnimationState spinningInWater = new ModAnimationState();
    public final ModAnimationState leftEyebrowUp = new ModAnimationState();
    public final ModAnimationState leftEyebrowDown = new ModAnimationState();
    public final ModAnimationState rightEyebrowUp = new ModAnimationState();
    public final ModAnimationState rightEyebrowDown = new ModAnimationState();
    public final ModAnimationState leftEyebrowAngry = new ModAnimationState();
    public final ModAnimationState rightEyebrowAngry = new ModAnimationState();
    public final ModAnimationState leftEyebrowSad = new ModAnimationState();
    public final ModAnimationState rightEyebrowSad = new ModAnimationState();
    public ItemEntity nearestItemEntity = null;
    public boolean targetFound = false;
    public boolean isPlayful = false;
    public int dontPlay;
    public float bodyRot;
    public static final TargetingConditions TEMPT_TARGETING = TargetingConditions.forNonCombat().ignoreLineOfSight();
    public LivingEntity leader;
    private int lastIdleSoundTick;
    public static double FOLLOW_LEADER_START_DISTANCE = 30.0;

    public boolean checkSpawnObstruction(LevelReader p_364787_) {
        return p_364787_.isUnobstructed((Entity)this);
    }

    public static boolean checkSurfaceAgeableWaterCreatureSpawnRules(EntityType<? extends ModMob> p_369363_, LevelAccessor p_370080_, EntitySpawnReason p_367384_, BlockPos p_370200_, RandomSource p_362509_) {
        if (p_362509_.nextInt(3) != 0) {
            return false;
        }
        int i = p_370080_.getSeaLevel();
        int j = i - 13;
        return p_370200_.getY() >= j && p_370200_.getY() <= i && p_370080_.getFluidState(p_370200_.below()).is(FluidTags.WATER) && p_370080_.getBlockState(p_370200_.above()).is(Blocks.WATER);
    }

    public ModMob(EntityType<? extends ModMob> p_29362_, Level p_29363_) {
        super(p_29362_, p_29363_);
        this.setTame(false, false);
        this.setPathfindingMalus(PathType.POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, -1.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        if (this.isInWater()) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new ModPanicGoal(this, 1.5));
        this.goalSelector.addGoal(1, (Goal)new ModBreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(2, (Goal)new ModFollowOwnerGoal(this, 1.25, 10.0f, 4.0f));
        this.goalSelector.addGoal(2, (Goal)new ModFollowLeaderGoal(this, 1.25, 10.0f, 4.0f));
        this.goalSelector.addGoal(3, (Goal)new ModFollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(4, (Goal)new ModTemptGoal(this, 1.25, p_332367_ -> p_332367_.is(Registrations.FOOD_ITEMS), true));
        this.goalSelector.addGoal(5, (Goal)new ModMeleeAttackGoal(this, 1.0, true));
        this.goalSelector.addGoal(6, (Goal)new ModEatGoal(this, 1.0, true));
        this.goalSelector.addGoal(7, (Goal)new ModRandomSwimmingOrWalkingGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(1, (Goal)new ModOwnerHurtByTargetGoal(this));
        this.targetSelector.addGoal(2, (Goal)new ModOwnerHurtTargetGoal(this));
        this.targetSelector.addGoal(4, new ModNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 10, true, false, (arg_0, arg_1) -> ((ModMob)this).isAngryAt(arg_0, arg_1)));
        this.targetSelector.addGoal(4, new ModNearestAttackableTargetGoal<LivingEntity>((Mob)this, LivingEntity.class, 100, true, false, this::canTargetLivingEntity));
        this.targetSelector.addGoal(5, new ModNearestAttackableFoodTargetGoal<ItemEntity>(this, ItemEntity.class, 20, true, false, this::allowedFood));
        this.targetSelector.addGoal(6, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public boolean canTargetLivingEntity(LivingEntity entity, ServerLevel p_366229_) {
        return entity != null && (this.getHealth() < this.getMaxHealth() || this.getRandom().nextInt(500) == 0) && entity instanceof AbstractSchoolingFish;
    }

    public boolean allowedFood(Entity entity, ServerLevel p_366229_) {
        if (entity.isAlive() && entity instanceof ItemEntity) {
            ItemEntity e = (ItemEntity)entity;
            if (this.getHealth() < this.getMaxHealth() && e.getItem().is(Registrations.FOOD_ITEMS)) {
                return true;
            }
        }
        return false;
    }

    public boolean isPassengerOfSameVehicle(Entity p_20366_) {
        return this.getRootVehicle() == p_20366_.getRootVehicle();
    }

    public void push(Entity p_20293_) {
        double d1;
        double d0;
        double d2;
        if (!this.isPassengerOfSameVehicle(p_20293_) && !p_20293_.noPhysics && !this.noPhysics && (d2 = Mth.absMax((double)(d0 = p_20293_.getX() - this.getX()), (double)(d1 = p_20293_.getZ() - this.getZ()))) >= (double)0.01f) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            if (this.isPushable()) {
                this.push(-d0, 0.0, -d1);
            }
            if (p_20293_.isPushable()) {
                p_20293_.push(d0, 0.0, d1);
            }
        }
    }

    public boolean wantsToAttack(LivingEntity enemy, LivingEntity owner) {
        TamableAnimal tamableanimal;
        AbstractHorse abstracthorse;
        if (enemy instanceof Creeper || enemy instanceof Ghast || enemy instanceof ArmorStand) {
            return false;
        }
        if (enemy instanceof ModMob) {
            ModMob mob = (ModMob)enemy;
            return !mob.isTame() || mob.getOwner() != owner;
        }
        if (enemy instanceof Player && this.isTame() && this.getOwner() == enemy) {
            return false;
        }
        if (enemy instanceof Player) {
            Player player1;
            Player player = (Player)enemy;
            if (owner instanceof Player && !(player1 = (Player)owner).canHarmPlayer(player)) {
                return false;
            }
        }
        if (enemy instanceof AbstractHorse && (abstracthorse = (AbstractHorse)enemy).isTamed()) {
            return false;
        }
        return !(enemy instanceof TamableAnimal) || !(tamableanimal = (TamableAnimal)enemy).isTame();
    }

    private void runBehaviors() {
        if (this.lastIdleSoundTick > 0) {
            --this.lastIdleSoundTick;
        }
        if (this.getRandom().nextInt(200) == 0 && this.lastIdleSoundTick <= 0 && !this.isPassenger()) {
            this.playSound((SoundEvent)Registrations.IDLE.get(), this.getSoundVolume(), this.getVoicePitch());
            this.level().broadcastEntityEvent((Entity)this, (byte)8);
            this.lastIdleSoundTick = 20 * (this.getRandom().nextInt(15) + 5);
        }
        if (this.tickCount % 100 == 0) {
            List list;
            if (this.leader != null && (!this.leader.isAlive() || this.distanceToSqr((Entity)this.leader) > 1500.0)) {
                this.leader = null;
            }
            if (!(this.isPassenger() || this.getBehaviorType() >= 3 || this.leader != this && this.leader != null || this.age < 0 || (list = this.level().getEntitiesOfClass(((Object)((Object)this)).getClass(), this.getBoundingBox().inflate(12.0, 8.0, 12.0))).isEmpty())) {
                for (ModMob mob : list) {
                    if (mob == this || !mob.isAlive()) continue;
                    if (mob.leader != null) {
                        this.leader = mob.leader;
                        break;
                    }
                    if (mob.leader == null && this.leader != this && this.leader != null) {
                        mob.leader = this.leader;
                        continue;
                    }
                    if (mob.leader != null || this.leader != this && this.leader != null) continue;
                    this.leader = this;
                    mob.leader = this;
                }
            }
        }
    }

    public void aiStep() {
        super.aiStep();
        if (this.dontPlay > 0) {
            --this.dontPlay;
        }
        if (this.isInWater() && !(this.moveControl instanceof ModSmoothSwimmingMoveControl)) {
            this.moveControl = new ModSmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.02f, true);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 10);
        } else if (!this.isInWater() && this.onGround() && this.moveControl instanceof ModSmoothSwimmingMoveControl) {
            this.moveControl = new MoveControl((Mob)this);
            this.lookControl = new ModSmoothSwimmingLookControl((Mob)this, 5);
        }
        if (!this.level().isClientSide()) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
            this.runBehaviors();
            if (this.getBehaviorType() == 0 && this.isInWater() && !this.isUnderWater()) {
                if (this.getRandom().nextInt(2) == 0) {
                    this.setBehaviorType(1);
                    this.nearestItemEntity = null;
                    this.dontPlay = 100;
                    this.level().broadcastEntityEvent((Entity)this, (byte)11);
                } else {
                    this.setBehaviorType(2);
                    this.nearestItemEntity = null;
                    this.dontPlay = 100;
                    this.level().broadcastEntityEvent((Entity)this, (byte)12);
                }
            }
            if (this.getBehaviorType() > 0 && this.getBehaviorType() < 3 && (!this.isInWater() || this.isUnderWater())) {
                this.setBehaviorType(0);
                this.level().broadcastEntityEvent((Entity)this, (byte)5);
            }
        } else {
            if (!this.breathing.isStarted()) {
                this.breathing.start(this.tickCount);
            }
            if (!this.onSide.isStarted()) {
                this.onSide.start(this.tickCount);
            }
            if (this.getBehaviorType() == 1 || this.getBehaviorType() == 2 || this.getBehaviorType() == 4) {
                boolean canStartAnimation = true;
                if (this.fromLayingOnBackToNormal.isStarted()) {
                    if (this.animationEnded(this.fromLayingOnBackToNormal, 1.25f)) {
                        this.fromLayingOnBackToNormal.stop();
                    } else {
                        canStartAnimation = false;
                    }
                }
                if (canStartAnimation) {
                    if (!this.layOnBack.isStarted() && !this.onBack.isStarted()) {
                        this.layOnBack.start(this.tickCount);
                    } else if (!this.onBack.isStarted() && this.layOnBack.isStarted() && this.animationEnded(this.layOnBack, 1.25f)) {
                        this.onBack.start(this.tickCount);
                        this.layOnBack.stop();
                        this.fromLayingOnBackToNormal.stop();
                    } else if (this.onBack.isStarted()) {
                        this.defaultAnimations();
                    }
                }
            } else {
                boolean canStartAnimation = true;
                if (this.layOnBack.isStarted()) {
                    if (this.animationEnded(this.layOnBack, 1.25f)) {
                        this.layOnBack.stop();
                        this.onBack.start(this.tickCount);
                    } else {
                        canStartAnimation = false;
                    }
                }
                if (canStartAnimation) {
                    if (!this.fromLayingOnBackToNormal.isStarted() && this.onBack.isStarted()) {
                        this.fromLayingOnBackToNormal.start(this.tickCount);
                        this.onBack.stop();
                    } else if (!this.onBack.isStarted() && this.fromLayingOnBackToNormal.isStarted() && this.animationEnded(this.fromLayingOnBackToNormal, 1.25f)) {
                        this.fromLayingOnBackToNormal.stop();
                        this.layOnBack.stop();
                    } else if (!this.isAggressive()) {
                        this.defaultAnimations();
                    }
                }
            }
        }
    }

    private void defaultAnimations() {
        int i;
        Level level = this.level();
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.wink, 0.75f) && this.animationEnded(this.tired, 6.0f)) {
            if (this.getRandom().nextInt(20) == 0) {
                this.tired.start(this.tickCount);
            } else {
                this.wink.start(this.tickCount);
            }
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.sniffing, 1.0f)) {
            this.sniffing.start(this.tickCount);
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.tail, 5.0f)) {
            this.tail.start(this.tickCount);
        }
        if (level.random.nextInt(200) == 0 && this.animationEnded(this.panting, 5.0f) && this.animationEnded(this.bite, 1.0f) && this.animationEnded(this.makeSound, 1.3f)) {
            this.panting.start(this.tickCount);
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.leftEar, 3.0f) && this.animationEnded(this.leftEar2, 3.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.leftEar.start(this.tickCount);
            } else {
                this.leftEar2.start(this.tickCount);
            }
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.rightEar, 3.0f) && this.animationEnded(this.rightEar2, 3.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.rightEar.start(this.tickCount);
            } else {
                this.rightEar2.start(this.tickCount);
            }
        }
        if (level.random.nextInt(50) == 0 && this.animationEnded(this.eyeLookUp, 1.75f) && this.animationEnded(this.eyeLookDown, 1.75f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.eyeLookUp.start(this.tickCount);
            } else {
                this.eyeLookDown.start(this.tickCount);
            }
        }
        if (level.random.nextInt(50) == 0 && this.animationEnded(this.eyeLookLeft, 1.75f) && this.animationEnded(this.eyeLookRight, 1.75f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.eyeLookLeft.start(this.tickCount);
            } else {
                this.eyeLookRight.start(this.tickCount);
            }
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.eyeRubbing, 4.0f) && this.animationEnded(this.earRubbing, 4.0f) && this.animationEnded(this.eat, 3.0f) && this.animationEnded(this.headLookUp, 3.0f) && this.animationEnded(this.headLookDown, 3.0f) && this.animationEnded(this.headLookMoreUp, 3.5f) && this.animationEnded(this.headLookMoreDown, 3.5f)) {
            i = this.getRandom().nextInt(4);
            if (i == 0) {
                this.headLookUp.start(this.tickCount);
            } else if (i == 1) {
                this.headLookDown.start(this.tickCount);
            } else if (i == 2) {
                this.headLookMoreUp.start(this.tickCount);
            } else {
                this.headLookMoreDown.start(this.tickCount);
            }
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.eyeRubbing, 4.0f) && this.animationEnded(this.earRubbing, 4.0f) && this.animationEnded(this.headLookLeft, 3.0f) && this.animationEnded(this.headLookRight, 3.0f) && this.animationEnded(this.headLookMoreLeft, 3.5f) && this.animationEnded(this.headLookMoreRight, 3.5f)) {
            i = this.getRandom().nextInt(4);
            if (i == 0) {
                this.headLookLeft.start(this.tickCount);
            } else if (i == 1) {
                this.headLookRight.start(this.tickCount);
            } else if (i == 2) {
                this.headLookMoreLeft.start(this.tickCount);
            } else {
                this.headLookMoreRight.start(this.tickCount);
            }
        }
        if (level.random.nextInt(100) == 0 && this.animationEnded(this.eyeRubbing, 4.0f) && this.animationEnded(this.earRubbing, 4.0f) && this.animationEnded(this.eat, 3.0f) && this.animationEnded(this.headTiltLeft, 2.5f) && this.animationEnded(this.headTiltRight, 2.5f) && this.animationEnded(this.headTiltMoreLeft, 3.0f) && this.animationEnded(this.headTiltMoreRight, 3.0f)) {
            i = this.getRandom().nextInt(4);
            if (i == 0) {
                this.headTiltLeft.start(this.tickCount);
            } else if (i == 1) {
                this.headTiltRight.start(this.tickCount);
            } else if (i == 2) {
                this.headTiltMoreLeft.start(this.tickCount);
            } else {
                this.headTiltMoreRight.start(this.tickCount);
            }
        }
        if (level.random.nextInt(300) == 0 && this.animationEnded(this.leftEyebrowDown, 2.0f) && this.animationEnded(this.leftEyebrowUp, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.leftEyebrowDown.start(this.tickCount);
            } else {
                this.leftEyebrowUp.start(this.tickCount);
            }
        }
        if (level.random.nextInt(300) == 0 && this.animationEnded(this.rightEyebrowDown, 2.0f) && this.animationEnded(this.rightEyebrowUp, 2.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.rightEyebrowDown.start(this.tickCount);
            } else {
                this.rightEyebrowUp.start(this.tickCount);
            }
        }
        if (level.random.nextInt(300) == 0 && this.animationEnded(this.leftEyebrowAngry, 4.0f) && this.animationEnded(this.leftEyebrowSad, 4.0f) && this.animationEnded(this.rightEyebrowAngry, 4.0f) && this.animationEnded(this.rightEyebrowSad, 4.0f)) {
            if (this.getRandom().nextInt(2) == 0) {
                this.leftEyebrowAngry.start(this.tickCount);
                this.rightEyebrowAngry.start(this.tickCount);
            } else {
                this.leftEyebrowSad.start(this.tickCount);
                this.rightEyebrowSad.start(this.tickCount);
            }
        }
        if ((this.getBehaviorType() == 1 || this.getBehaviorType() == 2 || this.getBehaviorType() == 1 || this.getBehaviorType() == 4) && level.random.nextInt(500) == 0 && this.animationEnded(this.eyeRubbing, 4.0f) && this.animationEnded(this.earRubbing, 4.0f)) {
            if (this.getRandom().nextInt(20) == 0) {
                this.eyeRubbing.start(this.tickCount);
            } else {
                this.earRubbing.start(this.tickCount);
            }
        }
    }

    public void travel(Vec3 p_30218_) {
        if (this.isInWater()) {
            this.moveRelative(0.1f, p_30218_);
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.85));
        } else {
            super.travel(p_30218_);
        }
    }

    protected BodyRotationControl createBodyControl() {
        return new ModBodyRotationControl((Mob)this);
    }

    public boolean animationEnded(ModAnimationState state, float animLength) {
        return (float)state.getTimeInMillis(this.tickCount) > animLength * 1000.0f;
    }

    public boolean doHurtTarget(ServerLevel p_368649_, Entity p_32257_) {
        this.level().broadcastEntityEvent((Entity)this, (byte)4);
        this.playSound(SoundEvents.FOX_BITE, 0.8f, this.getRandom().nextFloat() * 0.8f + 0.4f);
        return super.doHurtTarget(p_368649_, p_32257_);
    }

    public boolean isWithinMeleeAttackRange(Entity p_217067_) {
        return this.getAttackBoundingBox().inflate(0.5).intersects(this.getHitbox(p_217067_));
    }

    protected AABB getHitbox(Entity p_217067_) {
        AABB aabb = p_217067_.getBoundingBox();
        Entity entity = p_217067_.getVehicle();
        if (entity != null) {
            Vec3 vec3 = entity.getPassengerRidingPosition(p_217067_);
            return aabb.setMinY(Math.max(vec3.y, aabb.minY));
        }
        return aabb;
    }

    @Nullable
    public void setItemEntityTarget(Entity p_21544_) {
        if (p_21544_ != null) {
            if (p_21544_ instanceof ItemEntity) {
                this.nearestItemEntity = (ItemEntity)p_21544_;
                this.targetFound = true;
            } else {
                this.targetFound = false;
            }
        } else {
            this.targetFound = false;
        }
    }

    protected void positionRider(Entity p_289537_, Entity.MoveFunction p_289541_) {
        super.positionRider(p_289537_, p_289541_);
        if (p_289537_ instanceof ModMob) {
            ModMob passenger = (ModMob)p_289537_;
            ((LivingEntity)p_289537_).yBodyRot = this.yBodyRot;
            if (passenger.getAge() >= 0 || !this.isInWater() || this.getBehaviorType() == 0) {
                this.unRide();
            }
        }
    }

    protected void addPassenger(Entity p_20349_) {
        if (!this.isVehicle() || this.getAge() >= 0) {
            super.addPassenger(p_20349_);
        }
    }

    protected Vec3 getPassengerAttachmentPoint(Entity p_369514_, EntityDimensions p_366303_, float p_367794_) {
        float f = -0.1f;
        if (this.getPassengers().size() > 1) {
            int i = this.getPassengers().indexOf(p_369514_);
            f = i == 0 ? 0.2f : -0.6f;
            if (p_369514_ instanceof Animal) {
                f += 0.2f;
            }
        }
        float i = -0.3f;
        return new Vec3(0.0, (double)(i + 0.5f), (double)f).yRot(-this.getYRot() * ((float)Math.PI / 180));
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor p_146746_, DifficultyInstance p_146747_, EntitySpawnReason p_366700_, SpawnGroupData p_146749_) {
        if (this.getRandom().nextInt(100) < 3) {
            this.setFurColor(3);
        } else if (this.getRandom().nextInt(100) < 6) {
            this.setFurColor(2);
        } else if (this.getRandom().nextInt(100) < 25) {
            this.setFurColor(1);
        } else {
            this.setFurColor(0);
        }
        return super.finalizeSpawn(p_146746_, p_146747_, p_366700_, p_146749_);
    }

    protected float getWaterSlowDown() {
        return 0.8f;
    }

    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.TURTLE_SWIM;
    }

    protected SoundEvent getSwimSound() {
        return SoundEvents.TURTLE_SWIM;
    }

    public float getWalkTargetValue(BlockPos p_33895_, LevelReader p_33896_) {
        return 10.0f;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    protected PathNavigation createNavigation(Level p_30171_) {
        return new ModMobPathNavigation(this, p_30171_);
    }

    public boolean canBreatheUnderwater() {
        return true;
    }

    public void setAirSupply(int p_20302_) {
    }

    public int getMaxAirSupply() {
        return 4800;
    }

    public int getAirSupply() {
        return this.getMaxAirSupply();
    }

    protected void applyTamingSideEffects() {
        super.applyTamingSideEffects();
        this.setStats();
    }

    private void setStats() {
        if (this.isTame()) {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(25.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(4.0);
        } else {
            this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(8.0);
            this.getAttribute(Attributes.ATTACK_DAMAGE).setBaseValue(3.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createAnimalAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.MOVEMENT_SPEED, (double)0.15f).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.FOLLOW_RANGE, 16.0).add(Attributes.TEMPT_RANGE, 10.0).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public double getEyeY() {
        if (this.age < 0) {
            return this.position().y + (double)0.3f;
        }
        return super.getEyeY();
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    public boolean requiresCustomPersistence() {
        return true;
    }

    public boolean isFood(ItemStack p_30440_) {
        return p_30440_.is(Registrations.FOOD_ITEMS);
    }

    protected float getSoundVolume() {
        return 0.2f;
    }

    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().inflate(0.5);
    }

    public boolean hurtServer(ServerLevel p_368472_, DamageSource p_364880_, float p_366649_) {
        LivingEntity entity;
        if (this.isInvulnerableTo(p_368472_, p_364880_)) {
            return false;
        }
        if (this.getBehaviorType() == 4) {
            this.setBehaviorType(this.isTame() ? 6 : 0);
        }
        if (this.getPassengers().size() > 0) {
            this.ejectPassengers();
        }
        this.targetFound = false;
        this.nearestItemEntity = null;
        Entity entity2 = p_364880_.getEntity();
        if (entity2 instanceof LivingEntity && (entity = (LivingEntity)entity2).isAlive() && this.wantsToAttack(entity, this.getOwner())) {
            this.alertOthers(entity);
        }
        this.playSound((SoundEvent)Registrations.HURT.get(), this.getSoundVolume(), this.getVoicePitch());
        this.level().broadcastEntityEvent((Entity)this, (byte)8);
        return super.hurtServer(p_368472_, p_364880_, p_366649_);
    }

    public void alertOthers(LivingEntity entity) {
        double d0 = this.getFollowDistance();
        AABB aabb = AABB.unitCubeFromLowerCorner((Vec3)this.position()).inflate(d0, 10.0, d0);
        List list = this.level().getEntitiesOfClass(((Object)((Object)this)).getClass(), aabb, mob -> mob.isAlive() && mob.getTarget() == null);
        list.forEach(mob -> mob.setTarget(entity));
    }

    public double getFollowDistance() {
        return this.getAttributeValue(Attributes.FOLLOW_RANGE);
    }

    protected boolean canFlyToOwner() {
        return true;
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel p_148993_, AgeableMob p_148994_) {
        ModMob mob = (ModMob)this.getType().create((Level)p_148993_, EntitySpawnReason.BREEDING);
        if (this.isTame()) {
            mob.setOwnerReference(this.getOwnerReference());
            mob.setTame(true, true);
        }
        if (this.getRandom().nextInt(100) < 3) {
            mob.setFurColor(3);
        } else if (this.getRandom().nextInt(100) < 6) {
            mob.setFurColor(2);
        } else if (this.getRandom().nextInt(100) < 25) {
            mob.setFurColor(1);
        } else {
            mob.setFurColor(0);
        }
        return mob;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_335317_) {
        super.defineSynchedData(p_335317_);
        p_335317_.define(DATA_REMAINING_ANGER_TIME, (Object)0);
        p_335317_.define(BEHAVIOR, (Object)0);
        p_335317_.define(FUR_COLOR, (Object)0);
    }

    public void addAdditionalSaveData(ValueOutput p_29422_) {
        super.addAdditionalSaveData(p_29422_);
        this.addPersistentAngerSaveData(p_29422_);
        p_29422_.putInt("BehaviorType", this.getBehaviorType());
        p_29422_.putInt("FurColor", this.getFurColor());
    }

    public void readAdditionalSaveData(ValueInput p_29402_) {
        super.readAdditionalSaveData(p_29402_);
        this.readPersistentAngerSaveData(this.level(), p_29402_);
        this.setBehaviorType(p_29402_.getIntOr("BehaviorType", 0));
        this.setFurColor(p_29402_.getIntOr("FurColor", 0));
    }

    public int getFurColor() {
        return (Integer)this.entityData.get(FUR_COLOR);
    }

    private void setFurColor(int p_30398_) {
        this.entityData.set(FUR_COLOR, (Object)p_30398_);
    }

    public int getBehaviorType() {
        return (Integer)this.entityData.get(BEHAVIOR);
    }

    public void setBehaviorType(int p_30398_) {
        this.entityData.set(BEHAVIOR, (Object)p_30398_);
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(DATA_REMAINING_ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int p_30404_) {
        this.entityData.set(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(PERSISTENT_ANGER_TIME.sample(this.random));
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(@Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    public void tryToTame(Player p_336244_) {
        if (this.random.nextInt(3) == 0) {
            this.setBehaviorType(4);
            this.tame(p_336244_);
            this.navigation.stop();
            this.setTarget(null);
            this.level().broadcastEntityEvent((Entity)this, (byte)7);
        } else {
            this.level().broadcastEntityEvent((Entity)this, (byte)6);
        }
    }

    public InteractionResult mobInteract(Player p_30412_, InteractionHand p_30413_) {
        ItemStack itemstack = p_30412_.getItemInHand(p_30413_);
        if (this.isTame()) {
            if (this.isFood(itemstack)) {
                float f;
                this.usePlayerItem(p_30412_, p_30413_, itemstack);
                FoodProperties foodproperties = (FoodProperties)itemstack.get(DataComponents.FOOD);
                float f2 = f = foodproperties != null ? (float)foodproperties.nutrition() : 1.0f;
                if (this.level() instanceof ServerLevel) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)10);
                    if (this.getHealth() < this.getMaxHealth()) {
                        this.heal(2.0f * f);
                    }
                }
                return super.mobInteract(p_30412_, p_30413_);
            }
            InteractionResult interactionresult = super.mobInteract(p_30412_, p_30413_);
            if (!interactionresult.consumesAction() && this.isOwnedBy((LivingEntity)p_30412_)) {
                this.jumping = false;
                this.navigation.stop();
                this.setTarget(null);
                if (this.level() instanceof ServerLevel) {
                    int i = this.getBehaviorType();
                    if (i < 3) {
                        this.setBehaviorType(4);
                        this.level().broadcastEntityEvent((Entity)this, (byte)13);
                    } else if (i == 4) {
                        this.setBehaviorType(6);
                        this.leader = this;
                        this.level().broadcastEntityEvent((Entity)this, (byte)14);
                        this.playSound((SoundEvent)Registrations.HURT.get(), this.getSoundVolume(), this.getVoicePitch());
                    } else {
                        int j = this.getRandom().nextInt(3);
                        if (j == 0 || !this.isInWater()) {
                            this.setBehaviorType(0);
                            this.level().broadcastEntityEvent((Entity)this, (byte)5);
                        } else if (j == 1) {
                            this.setBehaviorType(1);
                            this.level().broadcastEntityEvent((Entity)this, (byte)11);
                        } else {
                            this.setBehaviorType(2);
                            this.level().broadcastEntityEvent((Entity)this, (byte)12);
                        }
                    }
                }
                return InteractionResult.SUCCESS.withoutItem();
            }
            return interactionresult;
        }
        if (!this.level().isClientSide() && this.isFood(itemstack)) {
            itemstack.consume(1, (LivingEntity)p_30412_);
            this.tryToTame(p_30412_);
            return InteractionResult.SUCCESS_SERVER;
        }
        return super.mobInteract(p_30412_, p_30413_);
    }

    public void handleEntityEvent(byte p_397414_) {
        if (p_397414_ == 4) {
            if (this.animationEnded(this.bite, 0.9f)) {
                this.bite.start(this.tickCount);
            }
        } else if (p_397414_ == 8) {
            if (this.animationEnded(this.makeSound, 1.3f) && this.animationEnded(this.bite, 1.0f) && this.animationEnded(this.panting, 4.25f)) {
                this.makeSound.start(this.tickCount);
            }
        } else if (p_397414_ == 10) {
            if (this.animationEnded(this.eat, 3.0f)) {
                this.eat.start(this.tickCount);
            }
        } else if (p_397414_ == 13) {
            this.setBehaviorType(4);
            this.nearestItemEntity = null;
            this.dontPlay = 100;
        } else if (p_397414_ == 14) {
            this.setBehaviorType(6);
            this.nearestItemEntity = null;
            this.dontPlay = 100;
            if (this.animationEnded(this.makeSound, 1.3f) && this.animationEnded(this.bite, 1.0f) && this.animationEnded(this.panting, 4.25f)) {
                this.makeSound.start(this.tickCount);
            }
        } else if (p_397414_ == 5) {
            this.setBehaviorType(0);
            this.nearestItemEntity = null;
            this.dontPlay = 100;
        } else if (p_397414_ == 11) {
            this.setBehaviorType(1);
            this.nearestItemEntity = null;
            this.dontPlay = 100;
        } else if (p_397414_ == 12) {
            this.setBehaviorType(2);
            this.nearestItemEntity = null;
            this.dontPlay = 100;
        } else {
            super.handleEntityEvent(p_397414_);
        }
    }
}

