/*
 * Decompiled with CFR 0.152.
 */
package aquariusplayz.animalgarden.seaotter.mob.goals;

import aquariusplayz.animalgarden.seaotter.mob.ModMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import org.jetbrains.annotations.Nullable;

public class ModFollowLeaderGoal
extends Goal {
    private final ModMob tamable;
    @Nullable
    private LivingEntity owner;
    private double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private final float startDistance;

    public ModFollowLeaderGoal(ModMob p_25294_, double p_25295_, float p_25296_, float p_25297_) {
        this.tamable = p_25294_;
        this.speedModifier = p_25295_;
        this.navigation = p_25294_.getNavigation();
        this.startDistance = p_25296_;
        this.stopDistance = p_25297_;
    }

    public boolean canUse() {
        if (this.tamable.getBehaviorType() > 3 || this.tamable.getTarget() != null) {
            return false;
        }
        LivingEntity leader = this.tamable.getOwner();
        if (leader != null && this.tamable.getBehaviorType() > 3 || leader == this.tamable) {
            return false;
        }
        leader = this.tamable.leader;
        if (leader == null) {
            return false;
        }
        if (this.tamable.distanceToSqr((Entity)leader) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.owner = leader;
        return true;
    }

    public boolean canContinueToUse() {
        if (this.navigation.isDone()) {
            return false;
        }
        return this.tamable.unableToMoveToOwner() ? false : !(this.tamable.distanceToSqr((Entity)this.owner) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void start() {
        this.timeToRecalcPath = 0;
    }

    public void stop() {
    }

    public void tick() {
        boolean flag;
        boolean bl = flag = this.owner != null && this.tamable.distanceToSqr((Entity)this.owner) >= 1500.0;
        if (!flag) {
            this.tamable.getLookControl().setLookAt((Entity)this.owner, 10.0f, (float)this.tamable.getMaxHeadXRot());
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.adjustedTickDelay(10);
            if (flag) {
                this.tamable.leader = null;
            } else {
                this.navigation.moveTo((Entity)this.owner, this.speedModifier);
            }
        }
    }
}

