/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mrbysco.armorposer.client.GlowHandler;
import com.mrbysco.armorposer.client.gui.ArmorStandScreen;
import com.mrbysco.armorposer.client.gui.widgets.ArmorGlowWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorGlowScreen
extends Screen {
    private static final int PADDING = 6;
    private ArmorGlowWidget[] armorListWidget = new ArmorGlowWidget[2];
    private ArmorGlowWidget.ListEntry selected = null;
    private final List<ArmorStand> armorStands;
    private Button locateButton;
    private Button modifyButton;
    public final ArmorStandScreen parentScreen;

    public ArmorGlowScreen(ArmorStandScreen parent) {
        super((Component)Component.translatable((String)"armorposer.gui.armor_list.list"));
        this.parentScreen = parent;
        this.minecraft = Minecraft.getInstance();
        if (this.minecraft.player == null) {
            this.onClose();
        }
        List armorStands = this.minecraft.level.getEntitiesOfClass(ArmorStand.class, this.minecraft.player.getBoundingBox().inflate(30.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE).stream().collect(Collectors.toList());
        armorStands.sort((armorStand, armorStand2) -> {
            double distance1 = armorStand.distanceToSqr((Entity)this.minecraft.player);
            double distance2 = armorStand2.distanceToSqr((Entity)this.minecraft.player);
            return Double.compare(distance1, distance2);
        });
        this.armorStands = Collections.unmodifiableList(armorStands);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int centerWidth = this.width / 2;
        int listWidth = this.width / 4 + 20;
        int structureWidth = this.width - listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 160);
        int y = this.height - 20 - 6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).bounds(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).build());
        int buttonWidth = closeButtonWidth / 2 - 1;
        this.locateButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.armor_list.locate"), b -> {
            if (this.selected != null && this.minecraft.player != null) {
                GlowHandler.startGlowing(this.selected.getArmorStand().getUUID());
                this.minecraft.player.lookAt(EntityAnchorArgument.Anchor.EYES, this.selected.getArmorStand().position());
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.locateButton);
        this.modifyButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.armor_list.modify"), b -> {
            if (this.selected != null && this.minecraft.player != null) {
                this.minecraft.setScreen((Screen)new ArmorStandScreen(this.selected.getArmorStand()));
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6 + buttonWidth + 2, y, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.modifyButton);
        int fullButtonHeight = 32;
        MutableComponent mutableComponent = Component.translatable((String)"armorposer.gui.armor_list.list");
        Objects.requireNonNull(this.getScreenFont());
        this.armorListWidget[0] = new ArmorGlowWidget(this, (Component)mutableComponent, true, listWidth, fullButtonHeight, y - 9 - 6);
        this.armorListWidget[0].setX(0);
        this.armorListWidget[0].setY(16);
        this.armorListWidget[0].setHeight(this.height);
        MutableComponent mutableComponent2 = Component.translatable((String)"armorposer.gui.armor_list.list2");
        Objects.requireNonNull(this.getScreenFont());
        this.armorListWidget[1] = new ArmorGlowWidget(this, (Component)mutableComponent2, false, listWidth, fullButtonHeight, y - 9 - 6);
        this.armorListWidget[1].setX(this.width - listWidth);
        this.armorListWidget[1].setY(16);
        this.armorListWidget[1].setHeight(this.height);
        this.addWidget((GuiEventListener)this.armorListWidget[0]);
        this.addWidget((GuiEventListener)this.armorListWidget[1]);
        this.updateCache();
    }

    public void tick() {
        if (this.armorListWidget[0].children().contains((Object)this.selected)) {
            this.armorListWidget[0].setSelected(this.selected);
            this.armorListWidget[1].setSelected((ArmorGlowWidget.ListEntry)null);
        } else if (this.armorListWidget[1].children().contains((Object)this.selected)) {
            this.armorListWidget[0].setSelected((ArmorGlowWidget.ListEntry)null);
            this.armorListWidget[1].setSelected(this.selected);
        }
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildPositionList(Consumer<T> ListViewConsumer, Function<ArmorStand, T> newEntry, boolean visible) {
        List<ArmorStand> filteredArmorStands = this.armorStands.stream().filter(armorStand -> visible == !armorStand.isInvisible()).toList();
        filteredArmorStands.forEach(stand -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ArmorStand)stand)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.armorListWidget[0].render(guiGraphics, mouseX, mouseY, partialTicks);
        this.armorListWidget[1].render(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(KeyEvent event) {
        return super.keyPressed(event);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void setSelected(ArmorGlowWidget.ListEntry previousEntry, ArmorGlowWidget.ListEntry entry, boolean visible) {
        if (this.selected == previousEntry) {
            this.selected = entry;
        } else if (this.selected == null || entry != null) {
            this.selected = entry;
        }
        this.updateCache();
    }

    private void updateCache() {
        this.locateButton.active = this.selected != null;
        this.modifyButton.active = this.selected != null;
    }

    public boolean mouseClicked(MouseButtonEvent buttonEvent, boolean flag) {
        return super.mouseClicked(buttonEvent, flag);
    }

    public void resize(Minecraft mc, int width, int height) {
        ArmorGlowWidget.ListEntry selected = this.selected;
        this.init(mc, width, height);
        this.selected = selected;
        this.updateCache();
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parentScreen);
    }

    public Minecraft getScreenMinecraft() {
        return this.minecraft;
    }

    public Font getScreenFont() {
        return this.font;
    }
}

