/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorGlowScreen;
import com.mrbysco.armorposer.client.gui.ArmorPosesScreen;
import com.mrbysco.armorposer.client.gui.SavePoseScreen;
import com.mrbysco.armorposer.client.gui.widgets.NumberFieldBox;
import com.mrbysco.armorposer.client.gui.widgets.SizeField;
import com.mrbysco.armorposer.client.gui.widgets.ToggleButton;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.platform.Services;
import com.mrbysco.armorposer.util.ArmorStandData;
import com.mrbysco.armorposer.util.ArmorUtil;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.LockIconButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Rotations;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.Mth;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3x2fStack;

public class ArmorStandScreen
extends Screen {
    private static final WidgetSprites MIRROR_POSE_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_pose"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_pose_highlighted"));
    private static final WidgetSprites MIRROR_LEGS_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_legs"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_legs_highlighted"));
    private static final WidgetSprites MIRROR_ARMS_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_arms"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_arms_highlighted"));
    private static final WidgetSprites SWAP_TO_HEAD_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/swap_to_head"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/swap_to_head_highlighted"));
    private static final WidgetSprites MIRROR_HANDS_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_hands"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/mirror_hands_highlighted"));
    private static final WidgetSprites BLOCK_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/block"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/block_highlighted"));
    private static final WidgetSprites ITEM_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/item"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/item_highlighted"));
    private static final WidgetSprites TOOL_SPRITES = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/tool"), ResourceLocation.fromNamespaceAndPath((String)"armorposer", (String)"widget/tool_highlighted"));
    private final ArmorStand entityArmorStand;
    private final ArmorStandData armorStandData;
    private final SavePoseScreen savePoseScreen;
    private final String[] buttonLabels = new String[]{"invisible", "base_plate", "gravity", "show_arms", "small", "name_visible", "rotation", "scale"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm", "position"};
    private final String version;
    private EditBox nameField;
    private String oldName;
    private String changedName;
    private Button renameButton;
    private NumberFieldBox rotationTextField;
    private final ToggleButton[] toggleButtons = new ToggleButton[6];
    protected final NumberFieldBox[] poseTextFields = new NumberFieldBox[21];
    private SizeField sizeField;
    private LockIconButton lockButton;
    private final boolean allowScrolling;
    private Vec3 lastSendOffset = new Vec3(0.0, 0.0, 0.0);
    private final Tooltip yPositionTooltip = Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.y_position"));
    private final Tooltip yPositionTooltipDisabled = Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.y_position.disabled").withStyle(ChatFormatting.RED));
    private final int whiteColor = ARGB.opaque((int)0xFFFFFF);

    public ArmorStandScreen(ArmorStand entityArmorStand) {
        super((Component)Component.translatable((String)"armorposer.gui.title"));
        this.entityArmorStand = entityArmorStand;
        this.oldName = entityArmorStand.hasCustomName() ? entityArmorStand.getName().getString() : this.getTitle().getString();
        this.armorStandData = new ArmorStandData();
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(Reference.LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)entityArmorStand.registryAccess());
            entityArmorStand.saveWithoutId((ValueOutput)output);
            CompoundTag tag = output.buildResult();
            if (tag.getCompoundOrEmpty("Pose").isEmpty()) {
                CompoundTag poseTag = ArmorUtil.writeAllPoses(entityArmorStand);
                tag.put("Pose", (Tag)poseTag);
            }
            this.armorStandData.readFromNBT(tag);
        }
        this.allowScrolling = Services.PLATFORM.allowScrolling();
        this.version = Services.PLATFORM.getModVersion();
        this.savePoseScreen = new SavePoseScreen(this);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void init() {
        int height;
        int width;
        int y;
        int x;
        int i;
        super.init();
        this.nameField = new EditBox(this.font, this.width / 2 - this.font.width(this.oldName) / 2, 10, 100, 20, (Component)Component.translatable((String)"armorposer.gui.label.name"));
        this.nameField.setValue(this.oldName);
        this.nameField.setTextColor(this.whiteColor);
        this.nameField.setTextColorUneditable(this.whiteColor);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(50);
        this.nameField.setTextShadow(true);
        this.nameField.setFocused(false);
        this.nameField.setResponder(text -> {
            this.changedName = text;
            this.updateRenameButton();
        });
        this.addWidget((GuiEventListener)this.nameField);
        this.renameButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.label.rename"), button -> {
            if (this.hasLevels() && !this.oldName.equals(this.changedName)) {
                this.entityArmorStand.setCustomName((Component)Component.literal((String)this.changedName));
                Services.PLATFORM.renameArmorStand(this.entityArmorStand, this.changedName);
                this.oldName = this.changedName;
                this.updateRenameButton();
            }
        }).bounds(this.width / 2, 24, 40, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.rename"))).build();
        this.addRenderableWidget((GuiEventListener)this.renameButton);
        this.renameButton.visible = false;
        this.renameButton.active = false;
        int offsetX = 110;
        int offsetY = 20;
        for (i = 0; i < this.toggleButtons.length; ++i) {
            x = offsetX;
            y = offsetY + i * 22;
            width = 40;
            height = 20;
            this.toggleButtons[i] = new ToggleButton.Builder(this.armorStandData.getBooleanValue(i), button -> {
                ToggleButton toggleButton;
                toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
                this.textFieldUpdated();
            }).bounds(x, y, width, height).build();
            this.addRenderableWidget((GuiEventListener)this.toggleButtons[i]);
            this.toggleButtons[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + this.buttonLabels[i]))));
        }
        this.rotationTextField = new NumberFieldBox(this.font, 1 + offsetX, 1 + offsetY + this.toggleButtons.length * 22, 38, 17, (Component)Component.translatable((String)"armorposer.gui.label.rotation"));
        this.rotationTextField.setValue(String.valueOf((int)this.armorStandData.rotation));
        this.rotationTextField.setMaxLength(4);
        this.addWidget((GuiEventListener)this.rotationTextField);
        this.rotationTextField.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.rotation")));
        this.sizeField = new SizeField(this.font, 1 + offsetX, offsetY + (this.toggleButtons.length + 1) * 22, 38, 17, (Component)Component.translatable((String)"armorposer.gui.label.scale"));
        this.sizeField.setValue(String.valueOf((double)this.entityArmorStand.getScale()));
        this.sizeField.setMaxLength(4);
        this.addWidget((GuiEventListener)this.sizeField);
        this.sizeField.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.scale")));
        if (this.minecraft != null && !Reference.canResize((Player)this.minecraft.player)) {
            this.sizeField.setEditable(false);
            this.sizeField.active = false;
            this.sizeField.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.size.disabled").withStyle(ChatFormatting.RED)));
        }
        offsetX = this.width - 20 - 100;
        for (i = 0; i < this.poseTextFields.length; ++i) {
            boolean lastRow;
            x = 1 + offsetX + i % 3 * 35;
            y = 1 + offsetY + i / 3 * 22;
            width = 28;
            height = 17;
            String value = String.valueOf((int)this.armorStandData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.font, x, y, width, height, (Component)Component.literal((String)value));
            this.poseTextFields[i].setValue(value);
            this.poseTextFields[i].setMaxLength(4);
            boolean bl = lastRow = i >= 18 && i < 21;
            if (lastRow) {
                this.poseTextFields[i].scrollMultiplier = 0.01f;
                this.poseTextFields[i].modValue = 2.1474836E9f;
                this.poseTextFields[i].decimalPoints = 2;
                this.poseTextFields[i].allowDecimal = true;
                this.poseTextFields[i].setMaxLength(6);
            }
            if (i % 3 == 0) {
                this.poseTextFields[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + (lastRow ? "x_position" : "x_rotation")))));
            } else if (i % 3 == 1) {
                this.poseTextFields[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + (lastRow ? "y_position" : "y_rotation")))));
            } else {
                this.poseTextFields[i].setTooltip(Tooltip.create((Component)Component.translatable((String)("armorposer.gui.tooltip." + (lastRow ? "z_position" : "z_rotation")))));
            }
            this.addWidget((GuiEventListener)this.poseTextFields[i]);
        }
        offsetY = this.height / 4 + 134;
        offsetX = 20;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.poses"), button -> this.minecraft.setScreen((Screen)new ArmorPosesScreen(this))).bounds(offsetX, offsetY, 130, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.poses"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.copy"), button -> {
            CompoundTag compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.minecraft != null) {
                this.minecraft.keyboardHandler.setClipboard(clipboardData);
            }
        }).bounds(offsetX, offsetY + 22, 42, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.copy"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.minecraft != null) {
                    clipboardData = this.minecraft.keyboardHandler.getClipboard();
                }
                if (clipboardData != null) {
                    CompoundTag compound;
                    compound.putBoolean("NoBasePlate", !(compound = TagParser.parseCompoundFully(clipboardData)).getBooleanOr("NoBasePlate", false));
                    compound.putBoolean("NoGravity", !compound.getBooleanOr("NoGravity", false));
                    this.readFieldsFromNBT(compound);
                    this.textFieldUpdated();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }).bounds(offsetX + 44, offsetY + 22, 42, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.paste"))).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"armorposer.gui.label.save"), button -> this.minecraft.setScreen((Screen)this.savePoseScreen)).bounds(offsetX + 88, offsetY + 22, 42, 20).tooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.save"))).build());
        offsetX = this.width - 20;
        int buttonsLeft = 9;
        int buttonOffset = -4;
        ImageButton mirrorPose = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_POSE_SPRITES, button -> {
            float[] head = new float[]{this.poseTextFields[0].getFloat(), this.poseTextFields[1].getFloat(), this.poseTextFields[2].getFloat()};
            this.poseTextFields[0].setValue(String.valueOf(head[0]));
            this.poseTextFields[1].setValue(String.valueOf(head[1] != 0.0f ? -head[1] : 0.0f));
            this.poseTextFields[2].setValue(String.valueOf(head[2] != 0.0f ? -head[2] : 0.0f));
            float[] body = new float[]{this.poseTextFields[3].getFloat(), this.poseTextFields[4].getFloat(), this.poseTextFields[5].getFloat()};
            this.poseTextFields[3].setValue(String.valueOf(body[0]));
            this.poseTextFields[4].setValue(String.valueOf(body[1] != 0.0f ? -body[1] : 0.0f));
            this.poseTextFields[5].setValue(String.valueOf(body[2] != 0.0f ? -body[2] : 0.0f));
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].setValue(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].setValue(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].setValue(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].setValue(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].setValue(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].setValue(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].setValue(String.valueOf(rightArm[0]));
            this.poseTextFields[13].setValue(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].setValue(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].setValue(String.valueOf(leftArm[0]));
            this.poseTextFields[16].setValue(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].setValue(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorPose.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.mirror")));
        ImageButton mirrorLegs = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_LEGS_SPRITES, button -> {
            float[] leftLeg = new float[]{this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()};
            float[] rightLeg = new float[]{this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()};
            this.poseTextFields[6].setValue(String.valueOf(rightLeg[0]));
            this.poseTextFields[7].setValue(String.valueOf(rightLeg[1] != 0.0f ? -rightLeg[1] : 0.0f));
            this.poseTextFields[8].setValue(String.valueOf(rightLeg[2] != 0.0f ? -rightLeg[2] : 0.0f));
            this.poseTextFields[9].setValue(String.valueOf(leftLeg[0]));
            this.poseTextFields[10].setValue(String.valueOf(leftLeg[1] != 0.0f ? -leftLeg[1] : 0.0f));
            this.poseTextFields[11].setValue(String.valueOf(leftLeg[2] != 0.0f ? -leftLeg[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorLegs.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.mirror_legs")));
        ImageButton mirrorArms = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_ARMS_SPRITES, button -> {
            float[] leftArm = new float[]{this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()};
            float[] rightArm = new float[]{this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()};
            this.poseTextFields[12].setValue(String.valueOf(rightArm[0]));
            this.poseTextFields[13].setValue(String.valueOf(rightArm[1] != 0.0f ? -rightArm[1] : 0.0f));
            this.poseTextFields[14].setValue(String.valueOf(rightArm[2] != 0.0f ? -rightArm[2] : 0.0f));
            this.poseTextFields[15].setValue(String.valueOf(leftArm[0]));
            this.poseTextFields[16].setValue(String.valueOf(leftArm[1] != 0.0f ? -leftArm[1] : 0.0f));
            this.poseTextFields[17].setValue(String.valueOf(leftArm[2] != 0.0f ? -leftArm[2] : 0.0f));
            this.textFieldUpdated();
        }));
        mirrorArms.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.mirror_arms")));
        ImageButton swapToHead = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, SWAP_TO_HEAD_SPRITES, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_WITH_HEAD)));
        swapToHead.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.swap_head")));
        ImageButton swapHands = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, MIRROR_HANDS_SPRITES, button -> Services.PLATFORM.swapSlots(this.entityArmorStand, SwapData.Action.SWAP_HANDS)));
        swapHands.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.swap_hands")));
        ImageButton blockButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, BLOCK_SPRITES, button -> {
            try {
                Vec3 pos = this.entityArmorStand.position();
                double xDiff = this.getDesiredOffset(pos.x, 1.0725);
                double yDiff = this.getDesiredOffset(pos.y, -0.655);
                double zDiff = this.getDesiredOffset(pos.z, 0.852);
                Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                switch (closestDegree) {
                    case 90: {
                        double newX = offset.z - 0.7;
                        double newZ = -offset.x + 1.18;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -180: {
                        double newX = -offset.x;
                        double newZ = -offset.z;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -90: {
                        double newX = -offset.z + 0.7;
                        double newZ = offset.x - 1.18;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                }
                CompoundTag tag = TagParser.parseCompoundFully((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:0b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-15.0f,135.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                this.readFieldsFromNBT(tag);
                this.toggleButtons[0].setValue(true);
                this.toggleButtons[2].setValue(true);
                this.toggleButtons[3].setValue(true);
                this.rotationTextField.setValue(String.valueOf(closestDegree));
                this.poseTextFields[18].setValue(String.valueOf(offset.x));
                this.poseTextFields[19].setValue(String.valueOf(offset.y));
                this.poseTextFields[20].setValue(String.valueOf(offset.z));
                this.textFieldUpdated();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }));
        blockButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.block")));
        ImageButton itemButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, ITEM_SPRITES, button -> {
            if (this.minecraft.hasShiftDown()) {
                try {
                    Vec3 pos = this.entityArmorStand.position();
                    double xDiff = this.getDesiredOffset(pos.x, 0.86);
                    double yDiff = this.getDesiredOffset(pos.y, -1.41);
                    double zDiff = this.getDesiredOffset(pos.z, -0.0625);
                    Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                    int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                    switch (closestDegree) {
                        case 90: {
                            double newX = offset.z + 1.12;
                            double newZ = -offset.x + 0.74;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -180: {
                            double newX = -offset.x;
                            double newZ = -offset.z;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -90: {
                            double newX = -offset.z - 1.12;
                            double newZ = offset.x - 0.74;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                    }
                    CompoundTag tag = TagParser.parseCompoundFully((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:1b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-90.0f,0.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                    this.readFieldsFromNBT(tag);
                    this.toggleButtons[0].setValue(true);
                    this.toggleButtons[2].setValue(true);
                    this.toggleButtons[3].setValue(true);
                    this.rotationTextField.setValue(String.valueOf(closestDegree));
                    this.poseTextFields[18].setValue(String.valueOf(offset.x));
                    this.poseTextFields[19].setValue(String.valueOf(offset.y));
                    this.poseTextFields[20].setValue(String.valueOf(offset.z));
                    this.textFieldUpdated();
                }
                catch (CommandSyntaxException pos) {}
            } else {
                try {
                    Vec3 pos = this.entityArmorStand.position();
                    double xDiff = this.getDesiredOffset(pos.x, 0.886);
                    double yDiff = this.getDesiredOffset(pos.y, -0.78);
                    double zDiff = this.getDesiredOffset(pos.z, 0.205);
                    Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                    int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                    switch (closestDegree) {
                        case 90: {
                            double newX = offset.z + 0.59;
                            double newZ = -offset.x + 0.78;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -180: {
                            double newX = -offset.x;
                            double newZ = -offset.z;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                        case -90: {
                            double newX = -offset.z - 0.59;
                            double newZ = offset.x - 0.78;
                            offset = new Vec3(newX, offset.y, newZ);
                            break;
                        }
                    }
                    CompoundTag tag = TagParser.parseCompoundFully((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:1b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[0.0f,0.0f,0.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                    this.readFieldsFromNBT(tag);
                    this.toggleButtons[0].setValue(true);
                    this.toggleButtons[2].setValue(true);
                    this.toggleButtons[3].setValue(true);
                    this.rotationTextField.setValue(String.valueOf(closestDegree));
                    this.poseTextFields[18].setValue(String.valueOf(offset.x));
                    this.poseTextFields[19].setValue(String.valueOf(offset.y));
                    this.poseTextFields[20].setValue(String.valueOf(offset.z));
                    this.textFieldUpdated();
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }));
        itemButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.item").append("\n").append((Component)Component.translatable((String)"armorposer.gui.tooltip.item2").withStyle(ChatFormatting.GRAY))));
        ImageButton toolButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, 20, 20, TOOL_SPRITES, button -> {
            try {
                Vec3 pos = this.entityArmorStand.position();
                double xDiff = this.getDesiredOffset(pos.x, 0.33);
                double yDiff = this.getDesiredOffset(pos.y, -1.285);
                double zDiff = this.getDesiredOffset(pos.z, 0.059999);
                Vec3 offset = new Vec3(xDiff, yDiff, zDiff);
                int closestDegree = Mth.roundToward((int)((int)this.rotationTextField.getFloat()), (int)90);
                switch (closestDegree) {
                    case 90: {
                        double newX = offset.z + 0.88;
                        double newZ = -offset.x - 0.34;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -180: {
                        double newX = -offset.x;
                        double newZ = -offset.z;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                    case -90: {
                        double newX = -offset.z - 0.88;
                        double newZ = offset.x + 0.34;
                        offset = new Vec3(newX, offset.y, newZ);
                        break;
                    }
                }
                CompoundTag tag = TagParser.parseCompoundFully((String)"{CustomNameVisible:0b,DisabledSlots:0,Invisible:0b,Invulnerable:0b,Move:[0.0d,0.0d,0.0d],NoBasePlate:0b,NoGravity:1b,Pose:{Body:[0.0f,0.0f,0.0f],Head:[0.0f,0.0f,0.0f],LeftArm:[0.0f,0.0f,0.0f],LeftLeg:[0.0f,0.0f,0.0f],RightArm:[-10.0f,0.0f,-90.0f],RightLeg:[0.0f,0.0f,0.0f]},Rotation:[0.0f],ShowArms:1b,Small:0b}");
                this.readFieldsFromNBT(tag);
                this.toggleButtons[0].setValue(true);
                this.toggleButtons[2].setValue(true);
                this.toggleButtons[3].setValue(true);
                this.rotationTextField.setValue(String.valueOf(closestDegree));
                this.poseTextFields[18].setValue(String.valueOf(offset.x));
                this.poseTextFields[19].setValue(String.valueOf(offset.y));
                this.poseTextFields[20].setValue(String.valueOf(offset.z));
                this.textFieldUpdated();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }));
        toolButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.tool")));
        this.lockButton = new LockIconButton(offsetX - 22 * --buttonsLeft - buttonOffset, offsetY, button -> {
            this.lockButton.setLocked(!this.lockButton.isLocked());
            this.textFieldUpdated();
        });
        this.addRenderableWidget((GuiEventListener)this.lockButton);
        this.lockButton.setLocked(this.armorStandData.getBooleanValue(6));
        this.lockButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.lock")));
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
            this.textFieldUpdated();
            this.minecraft.setScreen((Screen)null);
        }).bounds(offsetX - 194, offsetY + 22, 97, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> {
            this.poseTextFields[18].setValue("0");
            this.poseTextFields[19].setValue("0");
            this.poseTextFields[20].setValue("0");
            this.textFieldUpdated();
            this.updateEntity(this.armorStandData.writeToNBT());
            this.minecraft.setScreen((Screen)null);
        }).bounds(offsetX - 95, offsetY + 22, 97, 20).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.literal((String)"\ud83d\udca1"), button -> this.minecraft.setScreen((Screen)new ArmorGlowScreen(this))).bounds(0, 0, 16, 16).build());
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String s = this.nameField.getValue();
        this.init(minecraft, width, height);
        this.nameField.setValue(s);
    }

    private double getDesiredOffset(double posValue, double desiredValue) {
        double value = posValue - (double)((int)posValue);
        if (value < 0.0) {
            value = -value;
        }
        return desiredValue - value;
    }

    private boolean hasLevels() {
        if (this.minecraft == null || this.minecraft.player == null) {
            return false;
        }
        if (this.minecraft.player.getAbilities().instabuild) {
            return true;
        }
        return this.minecraft.player.experienceLevel >= 1;
    }

    private void updateRenameButton() {
        if (!this.oldName.equals(this.changedName)) {
            this.renameButton.visible = true;
            if (this.minecraft != null && this.minecraft.player != null) {
                if (!this.hasLevels()) {
                    this.renameButton.active = false;
                    this.renameButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.rename.disabled").withStyle(ChatFormatting.RED)));
                } else {
                    this.renameButton.active = true;
                }
            }
        } else {
            this.renameButton.visible = false;
            this.renameButton.active = false;
            this.renameButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"armorposer.gui.tooltip.rename")));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int i;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.nameField.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.rotationTextField.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.render(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.sizeField.render(guiGraphics, mouseX, mouseY, partialTicks);
        int offsetY = 20;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.font);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.drawString(this.font, I18n.get((String)("armorposer.gui.label." + this.buttonLabels[i]), (Object[])new Object[0]), x, y, this.whiteColor, true);
        }
        offsetX = this.width - 20 - 100;
        guiGraphics.drawString(this.font, "X", offsetX + 10, 7, this.whiteColor, true);
        guiGraphics.drawString(this.font, "Y", offsetX + 45, 7, this.whiteColor, true);
        guiGraphics.drawString(this.font, "Z", offsetX + 80, 7, this.whiteColor, true);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            String translatedLabel = I18n.get((String)("armorposer.gui.label." + this.sliderLabels[i]), (Object[])new Object[0]);
            int x = offsetX - this.font.width(translatedLabel) - 10;
            Objects.requireNonNull(this.font);
            int y = offsetY + i * 22 + (10 - 9 / 2);
            guiGraphics.drawString(this.font, translatedLabel, x, y, this.whiteColor, true);
        }
        Matrix3x2fStack pose = guiGraphics.pose();
        if (Services.PLATFORM.allowScrolling()) {
            pose.pushMatrix();
            pose.rotate(1.5708f);
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"armorposer.gui.label.scroll", (Object[])new Object[]{this.version}), 21, -this.width + 10, ARGB.opaque((int)0xAAAAAA), true);
            pose.popMatrix();
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void tick() {
        super.tick();
        boolean gravityEnabled = this.toggleButtons[2].getValue();
        NumberFieldBox yPositionField = this.poseTextFields[19];
        yPositionField.setEditable(!gravityEnabled);
        if (!gravityEnabled) {
            yPositionField.setTooltip(this.yPositionTooltip);
        } else {
            yPositionField.setFocused(false);
            yPositionField.setTooltip(this.yPositionTooltipDisabled);
        }
    }

    public boolean charTyped(CharacterEvent characterEvent) {
        boolean typed = super.charTyped(characterEvent);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double xScroll, double yScroll) {
        block7: {
            float multiplier;
            block6: {
                float f = multiplier = this.minecraft.hasShiftDown() ? 10.0f : 1.0f;
                if (!this.allowScrolling || !(yScroll > 0.0)) break block6;
                if (this.rotationTextField.canConsumeInput()) {
                    int nextValue = (int)(this.rotationTextField.getFloat() + 1.0f * multiplier);
                    this.rotationTextField.setValue(String.valueOf(nextValue));
                    this.rotationTextField.setCursorPosition(0);
                    this.rotationTextField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                if (this.sizeField.canConsumeInput()) {
                    float nextValue = (float)((double)this.sizeField.getFloat() + (double)(multiplier * this.sizeField.scrollMultiplier));
                    nextValue = Math.clamp(nextValue, this.sizeField.minValue, this.sizeField.maxValue);
                    this.sizeField.setValue(String.valueOf(nextValue));
                    this.sizeField.setCursorPosition(0);
                    this.sizeField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldBox textField : this.poseTextFields) {
                    if (!textField.canConsumeInput()) continue;
                    float nextValue = (textField.getFloat() + multiplier * textField.scrollMultiplier) % textField.modValue;
                    textField.setValue(String.valueOf(nextValue));
                    textField.setCursorPosition(0);
                    textField.setHighlightPos(0);
                    this.textFieldUpdated();
                    return true;
                }
                break block7;
            }
            if (!this.allowScrolling || !(yScroll < 0.0)) break block7;
            if (this.rotationTextField.canConsumeInput()) {
                int previousValue = (int)(this.rotationTextField.getFloat() - 1.0f * multiplier);
                this.rotationTextField.setValue(String.valueOf(previousValue));
                this.rotationTextField.setCursorPosition(0);
                this.rotationTextField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
            if (this.sizeField.canConsumeInput()) {
                float previousValue = (float)((double)this.sizeField.getFloat() - (double)(multiplier * this.sizeField.scrollMultiplier));
                previousValue = Math.clamp(previousValue, this.sizeField.minValue, this.sizeField.maxValue);
                this.sizeField.setValue(String.valueOf(previousValue));
                this.sizeField.setCursorPosition(0);
                this.sizeField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.canConsumeInput()) continue;
                float previousValue = (textField.getFloat() - multiplier * textField.scrollMultiplier) % textField.modValue;
                textField.setValue(String.valueOf(previousValue));
                textField.setCursorPosition(0);
                textField.setHighlightPos(0);
                this.textFieldUpdated();
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, xScroll, yScroll);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        int keyCode = keyEvent.key();
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].isFocused()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].moveCursorToEnd(false);
                this.poseTextFields[i].setFocused(false);
                int j = !this.minecraft.hasShiftDown() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].setFocused(true);
                this.poseTextFields[j].moveCursorTo(0, false);
                this.poseTextFields[j].setHighlightPos(this.poseTextFields[j].getValue().length());
            }
        } else {
            if (this.nameField.keyPressed(keyEvent)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.rotationTextField.keyPressed(keyEvent)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.sizeField.keyPressed(keyEvent)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.keyPressed(keyEvent)) continue;
                this.textFieldUpdated();
                return true;
            }
        }
        return super.keyPressed(keyEvent);
    }

    public boolean mouseClicked(MouseButtonEvent buttonEvent, boolean flag) {
        return super.mouseClicked(buttonEvent, flag);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    protected CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.putBoolean("Invisible", this.toggleButtons[0].getValue());
        compound.putBoolean("NoBasePlate", !this.toggleButtons[1].getValue());
        compound.putBoolean("NoGravity", !this.toggleButtons[2].getValue());
        compound.putBoolean("ShowArms", this.toggleButtons[3].getValue());
        compound.putBoolean("Small", this.toggleButtons[4].getValue());
        compound.putBoolean("CustomNameVisible", this.toggleButtons[5].getValue());
        compound.putBoolean("Invulnerable", this.lockButton.isLocked());
        compound.putInt("DisabledSlots", this.lockButton.isLocked() ? 0x3F3F3F : 0);
        compound.putDouble("Scale", (double)this.sizeField.getFloat());
        compound.store("Rotation", Vec2.CODEC, (Object)new Vec2(this.rotationTextField.getFloat(), 0.0f));
        CompoundTag poseTag = new CompoundTag();
        poseTag.store("Head", Rotations.CODEC, (Object)new Rotations(this.poseTextFields[0].getFloat(), this.poseTextFields[1].getFloat(), this.poseTextFields[2].getFloat()));
        poseTag.store("Body", Rotations.CODEC, (Object)new Rotations(this.poseTextFields[3].getFloat(), this.poseTextFields[4].getFloat(), this.poseTextFields[5].getFloat()));
        poseTag.store("LeftLeg", Rotations.CODEC, (Object)new Rotations(this.poseTextFields[6].getFloat(), this.poseTextFields[7].getFloat(), this.poseTextFields[8].getFloat()));
        poseTag.store("RightLeg", Rotations.CODEC, (Object)new Rotations(this.poseTextFields[9].getFloat(), this.poseTextFields[10].getFloat(), this.poseTextFields[11].getFloat()));
        poseTag.store("LeftArm", Rotations.CODEC, (Object)new Rotations(this.poseTextFields[12].getFloat(), this.poseTextFields[13].getFloat(), this.poseTextFields[14].getFloat()));
        poseTag.store("RightArm", Rotations.CODEC, (Object)new Rotations(this.poseTextFields[15].getFloat(), this.poseTextFields[16].getFloat(), this.poseTextFields[17].getFloat()));
        float offsetX = this.poseTextFields[18].getFloat();
        float offsetY = this.poseTextFields[19].getFloat();
        float offsetZ = this.poseTextFields[20].getFloat();
        double offsetXDiff = (double)offsetX - this.lastSendOffset.x;
        double offsetYDiff = (double)offsetY - this.lastSendOffset.y;
        double offsetZDiff = (double)offsetZ - this.lastSendOffset.z;
        compound.store("Move", Vec3.CODEC, (Object)new Vec3(offsetXDiff, offsetYDiff, offsetZDiff));
        this.lastSendOffset = new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
        compound.put("Pose", (Tag)poseTag);
        return compound;
    }

    protected void readFieldsFromNBT(CompoundTag compound) {
        CompoundTag armorStandTag = this.armorStandData.writeToNBT();
        armorStandTag.merge(compound);
        this.armorStandData.readFromNBT(armorStandTag);
        this.toggleButtons[0].setValue(compound.getBooleanOr("Invisible", false));
        this.toggleButtons[1].setValue(compound.getBooleanOr("NoBasePlate", false));
        this.toggleButtons[2].setValue(compound.getBooleanOr("NoGravity", false));
        this.toggleButtons[3].setValue(compound.getBooleanOr("ShowArms", false));
        this.toggleButtons[4].setValue(compound.getBooleanOr("Small", false));
        this.toggleButtons[5].setValue(compound.getBooleanOr("CustomNameVisible", false));
        this.lockButton.setLocked(compound.getBooleanOr("Invulnerable", false));
        this.sizeField.setValue(String.valueOf(compound.getDoubleOr("Scale", 1.0)));
        Optional rotation = compound.read("Rotation", Vec2.CODEC);
        if (rotation.isPresent()) {
            this.rotationTextField.setValue(String.valueOf(((Vec2)rotation.get()).x));
        }
        CompoundTag poseTag = compound.getCompoundOrEmpty("Pose");
        Rotations poseHeadTag = poseTag.read("Head", Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
        this.poseTextFields[0].setValue(String.valueOf(poseHeadTag.x()));
        this.poseTextFields[1].setValue(String.valueOf(poseHeadTag.y()));
        this.poseTextFields[2].setValue(String.valueOf(poseHeadTag.z()));
        Rotations poseBodyTag = poseTag.read("Body", Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
        this.poseTextFields[3].setValue(String.valueOf(poseBodyTag.x()));
        this.poseTextFields[4].setValue(String.valueOf(poseBodyTag.y()));
        this.poseTextFields[5].setValue(String.valueOf(poseBodyTag.z()));
        Rotations poseLeftLegTag = poseTag.read("LeftLeg", Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
        this.poseTextFields[6].setValue(String.valueOf(poseLeftLegTag.x()));
        this.poseTextFields[7].setValue(String.valueOf(poseLeftLegTag.y()));
        this.poseTextFields[8].setValue(String.valueOf(poseLeftLegTag.z()));
        Rotations poseRightLegTag = poseTag.read("RightLeg", Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
        this.poseTextFields[9].setValue(String.valueOf(poseRightLegTag.x()));
        this.poseTextFields[10].setValue(String.valueOf(poseRightLegTag.y()));
        this.poseTextFields[11].setValue(String.valueOf(poseRightLegTag.z()));
        Rotations poseLeftArmTag = poseTag.read("LeftArm", Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
        this.poseTextFields[12].setValue(String.valueOf(poseLeftArmTag.x()));
        this.poseTextFields[13].setValue(String.valueOf(poseLeftArmTag.y()));
        this.poseTextFields[14].setValue(String.valueOf(poseLeftArmTag.z()));
        Rotations poseRightArmTag = poseTag.read("RightArm", Rotations.CODEC).orElse(new Rotations(0.0f, 0.0f, 0.0f));
        this.poseTextFields[15].setValue(String.valueOf(poseRightArmTag.x()));
        this.poseTextFields[16].setValue(String.valueOf(poseRightArmTag.y()));
        this.poseTextFields[17].setValue(String.valueOf(poseRightArmTag.z()));
        Optional optionalOffset = compound.read("Move", Vec3.CODEC);
        if (optionalOffset.isPresent()) {
            Vec3 offset = (Vec3)optionalOffset.get();
            this.poseTextFields[18].setValue(String.valueOf(offset.x() + this.lastSendOffset.x));
            this.poseTextFields[19].setValue(String.valueOf(offset.y() + this.lastSendOffset.y));
            this.poseTextFields[20].setValue(String.valueOf(offset.z() + this.lastSendOffset.z));
            this.lastSendOffset = new Vec3(offset.x() + this.lastSendOffset.x, offset.y() + this.lastSendOffset.y, offset.z() + this.lastSendOffset.z);
        }
    }

    public static void openScreen(ArmorStand armorStandEntity) {
        Minecraft.getInstance().setScreen((Screen)new ArmorStandScreen(armorStandEntity));
    }

    public void updateEntity(CompoundTag compound) {
        Services.PLATFORM.updateEntity(this.entityArmorStand, compound);
    }
}

