/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.data;

import com.mrbysco.armorposer.Reference;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3;

public record SyncData(UUID entityUUID, CompoundTag tag) {
    public static final StreamCodec<FriendlyByteBuf, SyncData> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SyncData::entityUUID, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncData::tag, SyncData::new);
    private static final List<String> allowedKeys = List.of("Invisible", "NoBasePlate", "NoGravity", "ShowArms", "Small", "CustomNameVisible", "Invulnerable", "Pose", "DisabledSlots", "Pose", "Scale", "Move", "Rotation");

    public void handleData(ArmorStand armorStand, Player player) {
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(Reference.LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)armorStand.registryAccess());
            armorStand.saveWithoutId((ValueOutput)output);
            CompoundTag outputCompound = output.buildResult();
            if (!this.tag.isEmpty()) {
                AttributeInstance attributeInstance;
                double scale;
                List<String> keysToRemove = this.tag.keySet().stream().filter(key -> !allowedKeys.contains(key)).toList();
                keysToRemove.forEach(arg_0 -> ((CompoundTag)this.tag).remove(arg_0));
                outputCompound.merge(this.tag);
                armorStand.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)armorStand.registryAccess(), (CompoundTag)outputCompound));
                armorStand.setUUID(this.entityUUID);
                Vec3 offset = this.tag.read("Move", Vec3.CODEC).orElse(Vec3.ZERO);
                double xOffset = offset.x();
                double yOffset = offset.y();
                double zOffset = offset.z();
                if (xOffset != 0.0 || yOffset != 0.0 || zOffset != 0.0) {
                    armorStand.setPosRaw(armorStand.getX() + xOffset, armorStand.getY() + yOffset, armorStand.getZ() + zOffset);
                }
                if (Reference.canResize(player) && (scale = this.tag.getDoubleOr("Scale", 0.0)) > 0.0 && (attributeInstance = armorStand.getAttributes().getInstance(Attributes.SCALE)) != null) {
                    attributeInstance.setBaseValue(scale);
                }
            }
        }
    }
}

