/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.packets.handler;

import com.mrbysco.armorposer.packets.ArmorStandRenamePayload;
import com.mrbysco.armorposer.packets.ArmorStandSwapPayload;
import com.mrbysco.armorposer.packets.ArmorStandSyncPayload;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ServerPayloadHandler {
    private static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    public static ServerPayloadHandler getInstance() {
        return INSTANCE;
    }

    public void handleSwapData(ArmorStandSwapPayload swapData, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerLevel serverLevel;
            Entity entity;
            Level patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)patt0$temp).getEntity(swapData.data().entityUUID())) instanceof ArmorStand) {
                ArmorStand armorStandEntity = (ArmorStand)entity;
                swapData.data().handleData(armorStandEntity);
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"armorposer.networking.swap.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSyncData(ArmorStandSyncPayload syncData, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerLevel serverLevel;
            Entity entity;
            Level patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)patt0$temp).getEntity(syncData.data().entityUUID())) instanceof ArmorStand) {
                ArmorStand armorStandEntity = (ArmorStand)entity;
                syncData.data().handleData(armorStandEntity, context.player());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"armorposer.networking.sync.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleRenameData(ArmorStandRenamePayload renameData, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerLevel serverLevel;
            Entity entity;
            Level patt0$temp;
            if (context.player() != null && (patt0$temp = context.player().level()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)patt0$temp).getEntity(renameData.data().entityUUID())) instanceof ArmorStand) {
                ArmorStand armorStandEntity = (ArmorStand)entity;
                renameData.data().handleData(armorStandEntity, context.player());
            }
        }).exceptionally(e -> {
            context.disconnect((Component)Component.translatable((String)"armorposer.networking.rename.failed", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }
}

