/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.platform;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.config.PoserConfig;
import com.mrbysco.armorposer.data.RenameData;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.data.SyncData;
import com.mrbysco.armorposer.packets.ArmorStandRenamePayload;
import com.mrbysco.armorposer.packets.ArmorStandSwapPayload;
import com.mrbysco.armorposer.packets.ArmorStandSyncPayload;
import com.mrbysco.armorposer.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueOutput;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public void updateEntity(ArmorStand armorStand, CompoundTag compound) {
        try (ProblemReporter.ScopedCollector problemreporter$scopedcollector = new ProblemReporter.ScopedCollector(Reference.LOGGER);){
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemreporter$scopedcollector, (HolderLookup.Provider)armorStand.registryAccess());
            armorStand.saveWithoutId((ValueOutput)output);
            CompoundTag outputCompound = output.buildResult();
            outputCompound.merge(compound);
            armorStand.load(TagValueInput.create((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)armorStand.registryAccess(), (CompoundTag)outputCompound));
            SyncData data = new SyncData(armorStand.getUUID(), outputCompound);
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new ArmorStandSyncPayload(data), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void swapSlots(ArmorStand armorStand, SwapData.Action action) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ArmorStandSwapPayload(new SwapData(armorStand.getUUID(), action)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void renameArmorStand(ArmorStand armorStand, String newName) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ArmorStandRenamePayload(new RenameData(armorStand.getUUID(), newName)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean allowScrolling() {
        return (Boolean)PoserConfig.COMMON.allowScrolling.get();
    }

    @Override
    public Path getUserPresetFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isResizeRestrictedToOPS() {
        return (Boolean)PoserConfig.COMMON.restrictResizeToOP.get();
    }

    @Override
    public List<? extends String> getResizeWhitelist() {
        return (List)PoserConfig.COMMON.resizeWhitelist.get();
    }

    @Override
    public boolean nameBasedFeatures() {
        return (Boolean)PoserConfig.COMMON.nameBasedFeatures.get();
    }

    @Override
    public String getModVersion() {
        return ModList.get().getModFileById("armorposer").versionString();
    }
}

