/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import com.mrbysco.armorposer.Reference;
import com.mrbysco.armorposer.client.gui.ArmorGlowScreen;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ArmorStand;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ArmorGlowWidget
extends ObjectSelectionList<ListEntry> {
    private final ArmorGlowScreen parent;
    private final int listWidth;
    private final Component title;

    public ArmorGlowWidget(ArmorGlowScreen parent, Component title, boolean visible, int listWidth, int top, int bottom) {
        Minecraft minecraft = parent.getScreenMinecraft();
        Objects.requireNonNull(parent.getScreenFont());
        super(minecraft, listWidth, bottom - top, top, 9 * 2 + 16);
        this.parent = parent;
        this.title = title;
        this.listWidth = listWidth;
        this.refreshList(visible);
    }

    protected int scrollBarX() {
        return this.getX() + this.listWidth - 6;
    }

    public int getRowWidth() {
        return this.listWidth;
    }

    public void refreshList(boolean visible) {
        this.clearEntries();
        this.parent.buildPositionList(x$0 -> this.addEntry((AbstractSelectionList.Entry)x$0), location -> new ListEntry((ArmorStand)location, this.parent), visible);
    }

    protected void renderSelection(GuiGraphics guiGraphics, ListEntry listEntry, int p_240142_) {
        int x1 = listEntry.getX();
        int y1 = listEntry.getY();
        int x2 = x1 + listEntry.getWidth();
        int y2 = y1 + listEntry.getHeight();
        guiGraphics.fillGradient(x1, y1, x2, y2, -1945083888, -1676648432);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        guiGraphics.fillGradient(this.getX(), 0, this.getX() + this.listWidth, this.parent.height, -1945104368, -1676668912);
        super.renderWidget(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawCenteredString(this.parent.getScreenFont(), this.title, this.getX() + this.listWidth / 2, 2, ARGB.opaque((int)0xFFFFFF));
    }

    public void setSelected(@Nullable ListEntry selected) {
        this.parent.setSelected((ListEntry)this.getSelected(), selected, this.visible);
        super.setSelected((AbstractSelectionList.Entry)selected);
    }

    public class ListEntry
    extends ObjectSelectionList.Entry<ListEntry> {
        private final ArmorGlowScreen parent;
        private final ArmorStand armorStand;
        private final float scale;
        private final boolean showPlate;
        private final boolean locked;

        ListEntry(ArmorStand armorStand, ArmorGlowScreen parent) {
            this.armorStand = armorStand;
            this.parent = parent;
            this.scale = armorStand.getScale();
            this.showPlate = armorStand.showBasePlate();
            this.locked = armorStand.isInvulnerable();
        }

        public void renderContent(GuiGraphics guiGraphics, int mouseX, int mouseY, boolean hovered, float partialTick) {
            Font font = this.parent.getScreenFont();
            int left = this.getContentX();
            int top = this.getContentY();
            AbstractWidget.renderScrollingString((GuiGraphics)guiGraphics, (Font)font, (Component)this.getPositionComponent(), (int)left, (int)(top + 10), (int)(left + ArmorGlowWidget.this.width - 18), (int)(top + 20), (int)-1);
            if (this.isMouseOver(mouseX, mouseY)) {
                MutableComponent component = Component.translatable((String)"armorposer.gui.armor_list.stats", (Object[])new Object[]{Float.valueOf(this.scale)});
                guiGraphics.setTooltipForNextFrame(font, (Component)component, mouseX, mouseY);
            }
            if (this.isVisible() && ArmorGlowWidget.this.getSelected() == this) {
                this.renderPose(guiGraphics, left + 16, top + 28, partialTick);
            }
        }

        public ArmorStand getArmorStand() {
            return this.armorStand;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public boolean isVisible() {
            return !this.armorStand.isInvisible();
        }

        public void renderPose(GuiGraphics guiGraphics, int xPos, int yPos, float partialTick) {
            if (this.armorStand != null) {
                int startX = xPos - 40;
                int startY = yPos - 60;
                int endX = xPos + 40;
                int endY = yPos + 60;
                InventoryScreen.renderEntityInInventory((GuiGraphics)guiGraphics, (int)startX, (int)startY, (int)endX, (int)endY, (float)20.0f, (Vector3f)Reference.ARMOR_STAND_TRANSLATION, (Quaternionf)Reference.ARMOR_STAND_ANGLE, (Quaternionf)null, (LivingEntity)this.armorStand);
            }
        }

        public Component getPositionComponent() {
            MutableComponent component = Component.literal((String)this.getArmorStand().blockPosition().toShortString());
            if (this.showPlate) {
                component = component.withStyle(ChatFormatting.UNDERLINE);
            }
            if (this.locked) {
                component = component.append(" \ud83d\udd12").withStyle(ChatFormatting.BOLD);
            }
            return component;
        }

        public Component getNarration() {
            return this.getPositionComponent();
        }
    }
}

