/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.papierkorb2292.command_crafter.editor.CommandCrafterLanguageClient;
import net.papierkorb2292.command_crafter.editor.EditorURI;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.FileAnalyseHandler;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 52\u00020\u0001:\u00015B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\r\u001a\r\u0012\t\u0012\u00070\u0002\u00a2\u0006\u0002\b\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J5\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0019J\u001d\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u001d\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010#\u001a\u0004\b$\u0010\u000eR\"\u0010\b\u001a\u00020\u00078\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\b\u0010%\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0017\u0010+\u001a\u00020*8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.R*\u0010/\u001a\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104\u00a8\u00066"}, d2={"Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "", "", "uri", "", "Ljava/lang/StringBuffer;", "lines", "", "version", "<init>", "(Ljava/lang/String;Ljava/util/List;I)V", "", "Lkotlin/jvm/internal/EnhancedNullability;", "stringifyLines", "()Ljava/util/List;", "Lorg/eclipse/lsp4j/TextDocumentContentChangeEvent;", "change", "", "applyContentChange", "(Lorg/eclipse/lsp4j/TextDocumentContentChangeEvent;)V", "startLine", "endLine", "startChar", "endChar", "newText", "(IIIILjava/lang/String;)V", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "languageServer", "Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyzeFile", "(Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;)Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/String;", "getUri", "()Ljava/lang/String;", "Ljava/util/List;", "getLines", "I", "getVersion", "()I", "setVersion", "(I)V", "Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "parsedUri", "Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "getParsedUri", "()Lnet/papierkorb2292/command_crafter/editor/EditorURI;", "analyzingResult", "Ljava/util/concurrent/CompletableFuture;", "getAnalyzingResult", "()Ljava/util/concurrent/CompletableFuture;", "setAnalyzingResult", "(Ljava/util/concurrent/CompletableFuture;)V", "Companion", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nOpenFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFile.kt\nnet/papierkorb2292/command_crafter/editor/OpenFile\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1563#2:111\n1634#2,3:112\n*S KotlinDebug\n*F\n+ 1 OpenFile.kt\nnet/papierkorb2292/command_crafter/editor/OpenFile\n*L\n21#1:111\n21#1:112,3\n*E\n"})
public final class OpenFile {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String uri;
    @NotNull
    private final List<StringBuffer> lines;
    private int version;
    @NotNull
    private final EditorURI parsedUri;
    @Nullable
    private CompletableFuture<AnalyzingResult> analyzingResult;
    @NotNull
    public static final String LINE_SEPARATOR = "\r\n";

    public OpenFile(@NotNull String uri, @NotNull List<StringBuffer> lines, int version) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(lines, (String)"lines");
        this.uri = uri;
        this.lines = lines;
        this.version = version;
        this.parsedUri = EditorURI.Companion.parseURI$default(EditorURI.Companion, this.uri, false, 2, null);
    }

    public /* synthetic */ OpenFile(String string, List list, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(string, list, n);
    }

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    @NotNull
    public final List<StringBuffer> getLines() {
        return this.lines;
    }

    public final int getVersion() {
        return this.version;
    }

    public final void setVersion(int n) {
        this.version = n;
    }

    @NotNull
    public final EditorURI getParsedUri() {
        return this.parsedUri;
    }

    @Nullable
    public final CompletableFuture<AnalyzingResult> getAnalyzingResult() {
        return this.analyzingResult;
    }

    public final void setAnalyzingResult(@Nullable CompletableFuture<AnalyzingResult> completableFuture) {
        this.analyzingResult = completableFuture;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> stringifyLines() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.lines;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StringBuffer stringBuffer = (StringBuffer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        return (List)destination$iv$iv;
    }

    public final void applyContentChange(@NotNull TextDocumentContentChangeEvent change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        int n = change.getRange().getStart().getLine();
        int n2 = change.getRange().getEnd().getLine();
        int n3 = change.getRange().getStart().getCharacter();
        int n4 = change.getRange().getEnd().getCharacter();
        String string = change.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.applyContentChange(n, n2, n3, n4, string);
    }

    public final void applyContentChange(int startLine, int endLine, int startChar, int endChar, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        if (startLine >= this.lines.size() || endLine >= this.lines.size() || startLine > endLine || startLine == endLine && startChar > endChar) {
            return;
        }
        Iterator newLines = StringsKt.lineSequence((CharSequence)newText).iterator();
        StringBuffer startLineText = this.lines.get(startLine);
        StringBuffer endLineText = this.lines.get(endLine);
        int secondLine = startLine + 1;
        if (startLine == endLine) {
            if (!newLines.hasNext()) {
                startLineText.delete(startChar, endChar);
                return;
            }
            String firstLineText = (String)newLines.next();
            if (!newLines.hasNext()) {
                startLineText.replace(startChar, endChar, firstLineText);
                return;
            }
            String endText = startLineText.substring(endChar);
            startLineText.replace(startChar, startLineText.length(), firstLineText);
            int preAddLineCount = this.lines.size();
            String last = OpenFile.applyContentChange$addNewLinesAndReturnLast(this.lines, newLines, secondLine);
            int n = secondLine + this.lines.size() - preAddLineCount;
            StringBuffer stringBuffer = new StringBuffer(last).append(endText);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuffer, (String)"append(...)");
            this.lines.add(n, stringBuffer);
        } else {
            startLineText.replace(startChar, startLineText.length(), newLines.hasNext() ? (String)newLines.next() : "");
            if (endLine > secondLine) {
                this.lines.subList(secondLine, endLine).clear();
            }
            if (!newLines.hasNext()) {
                startLineText.append(endLineText.substring(endChar));
                this.lines.remove(secondLine);
                return;
            }
            String last = OpenFile.applyContentChange$addNewLinesAndReturnLast(this.lines, newLines, secondLine);
            endLineText.replace(0, endChar, last);
        }
    }

    @Nullable
    public final CompletableFuture<AnalyzingResult> analyzeFile(@NotNull MinecraftLanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        CompletableFuture<AnalyzingResult> runningAnalyzer = this.analyzingResult;
        if (runningAnalyzer != null) {
            return runningAnalyzer;
        }
        for (FileAnalyseHandler analyzer : MinecraftLanguageServer.Companion.getAnalyzers()) {
            CompletableFuture<AnalyzingResult> completableFuture;
            if (!analyzer.canHandle(this)) continue;
            int version = this.version;
            CompletableFuture<AnalyzingResult> newRunningAnalyzer = completableFuture = analyzer.analyzeAsync(this, languageServer);
            boolean bl = false;
            this.analyzingResult = newRunningAnalyzer;
            newRunningAnalyzer.thenAccept(arg_0 -> OpenFile.analyzeFile$lambda$3$lambda$2(arg_0 -> OpenFile.analyzeFile$lambda$3$lambda$1(this, version, languageServer, arg_0), arg_0));
            return completableFuture;
        }
        return null;
    }

    private static final String applyContentChange$addNewLinesAndReturnLast(List<StringBuffer> lines, Iterator<String> newLines, int start) {
        int currentLine = start;
        Iterator<String> iterator = newLines;
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (!newLines.hasNext()) {
                return line;
            }
            lines.add(currentLine++, new StringBuffer(line));
        }
        return "";
    }

    private static final Unit analyzeFile$lambda$3$lambda$1(OpenFile this$0, int $version, MinecraftLanguageServer $languageServer, AnalyzingResult it) {
        block1: {
            if (this$0.version != $version) {
                return Unit.INSTANCE;
            }
            MinecraftLanguageServer.Companion.fillDiagnosticsSource(it.getDiagnostics());
            CommandCrafterLanguageClient commandCrafterLanguageClient = $languageServer.getClient();
            if (commandCrafterLanguageClient == null) break block1;
            commandCrafterLanguageClient.publishDiagnostics(new PublishDiagnosticsParams(this$0.uri, it.getDiagnostics(), Integer.valueOf($version)));
        }
        return Unit.INSTANCE;
    }

    private static final void analyzeFile$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00042\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\b\b\u0002\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00048\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lnet/papierkorb2292/command_crafter/editor/OpenFile$Companion;", "", "<init>", "()V", "", "content", "", "Ljava/lang/StringBuffer;", "linesFromString", "(Ljava/lang/String;)Ljava/util/List;", "", "lines", "linesFromStrings", "(Ljava/util/List;)Ljava/util/List;", "uri", "", "version", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "fromString", "(Ljava/lang/String;Ljava/lang/String;I)Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "fromLines", "(Ljava/lang/String;Ljava/util/List;I)Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "LINE_SEPARATOR", "Ljava/lang/String;", "command-crafter"})
    @SourceDebugExtension(value={"SMAP\nOpenFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFile.kt\nnet/papierkorb2292/command_crafter/editor/OpenFile$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1634#2,3:111\n1634#2,3:114\n*S KotlinDebug\n*F\n+ 1 OpenFile.kt\nnet/papierkorb2292/command_crafter/editor/OpenFile$Companion\n*L\n16#1:111,3\n18#1:114,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<StringBuffer> linesFromString(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return this.linesFromStrings(StringsKt.lines((CharSequence)content));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<StringBuffer> linesFromStrings(@NotNull List<String> lines) {
            void var3_3;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Iterable iterable = lines;
            Collection destination$iv = new ArrayList(lines.size());
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                String string = (String)item$iv;
                Collection collection = destination$iv;
                boolean bl = false;
                collection.add(new StringBuffer((String)p0));
            }
            return (List)var3_3;
        }

        @NotNull
        public final OpenFile fromString(@NotNull String uri, @NotNull String content, int version) {
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            return this.fromLines(uri, StringsKt.lines((CharSequence)content), version);
        }

        public static /* synthetic */ OpenFile fromString$default(Companion companion, String string, String string2, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.fromString(string, string2, n);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final OpenFile fromLines(@NotNull String uri, @NotNull List<String> lines, int version) {
            void destination$iv;
            void $this$mapTo$iv;
            Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
            Intrinsics.checkNotNullParameter(lines, (String)"lines");
            Iterable iterable = lines;
            Collection collection = new ArrayList(lines.size());
            String string = uri;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                String string2 = (String)item$iv;
                void var12_12 = destination$iv;
                boolean bl = false;
                var12_12.add(new StringBuffer((String)p0));
            }
            int n = version;
            List list = (List)destination$iv;
            String string3 = string;
            return new OpenFile(string3, list, n);
        }

        public static /* synthetic */ OpenFile fromLines$default(Companion companion, String string, List list, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = 0;
            }
            return companion.fromLines(string, list, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

