/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.OpenFile;
import net.papierkorb2292.command_crafter.editor.processing.PackContentFileType;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.FileAnalyseHandler;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ%\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eR#\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\u000f8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\"\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/FileTypeDispatchingAnalyzer;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/FileAnalyseHandler;", "<init>", "()V", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "file", "", "canHandle", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;)Z", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "languageServer", "Ljava/util/concurrent/CompletableFuture;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyzeAsync", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;)Ljava/util/concurrent/CompletableFuture;", "", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "analyzers", "Ljava/util/Map;", "getAnalyzers", "()Ljava/util/Map;", "Lkotlin/Function1;", "analyzerGetter", "Lkotlin/jvm/functions/Function1;", "command-crafter"})
public final class FileTypeDispatchingAnalyzer
implements FileAnalyseHandler {
    @NotNull
    public static final FileTypeDispatchingAnalyzer INSTANCE = new FileTypeDispatchingAnalyzer();
    @NotNull
    private static final Map<PackContentFileType, FileAnalyseHandler> analyzers = new LinkedHashMap();
    @NotNull
    private static final Function1<OpenFile, FileAnalyseHandler> analyzerGetter = UtilKt.memoizeLast(FileTypeDispatchingAnalyzer::analyzerGetter$lambda$0);

    private FileTypeDispatchingAnalyzer() {
    }

    @NotNull
    public final Map<PackContentFileType, FileAnalyseHandler> getAnalyzers() {
        return analyzers;
    }

    @Override
    public boolean canHandle(@NotNull OpenFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileAnalyseHandler fileAnalyseHandler = (FileAnalyseHandler)analyzerGetter.invoke((Object)file);
        return fileAnalyseHandler != null ? fileAnalyseHandler.canHandle(file) : false;
    }

    @Override
    @NotNull
    public CompletableFuture<AnalyzingResult> analyzeAsync(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        Object object = analyzerGetter.invoke((Object)file);
        Intrinsics.checkNotNull((Object)object);
        return ((FileAnalyseHandler)object).analyzeAsync(file, languageServer);
    }

    @Override
    @NotNull
    public AnalyzingResult analyze(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        return FileAnalyseHandler.DefaultImpls.analyze(this, file, languageServer);
    }

    private static final FileAnalyseHandler analyzerGetter$lambda$0(OpenFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Map<PackContentFileType, FileAnalyseHandler> map2 = analyzers;
        PackContentFileType.ParsedPath parsedPath = PackContentFileType.Companion.parsePath(file.getParsedUri().getPath());
        return map2.get((Object)(parsedPath != null ? parsedPath.getType() : null));
    }
}

