/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.context.StringRange;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2483;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTree;
import net.papierkorb2292.command_crafter.editor.processing.TokenType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\fJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/NbtSemanticTokenProvider;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$SemanticTokenProvider;", "Lnet/minecraft/class_2520;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "tree", "", "input", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;Ljava/lang/String;)V", "map", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$TokenInfo;", "getMapNameTokenInfo", "(Lnet/minecraft/class_2520;)Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$TokenInfo;", "node", "getNodeTokenInfo", "", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree$AdditionalToken;", "getAdditionalTokens", "(Lnet/minecraft/class_2520;)Ljava/util/List;", "Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "getTree", "()Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTree;", "Ljava/lang/String;", "getInput", "()Ljava/lang/String;", "command-crafter"})
public final class NbtSemanticTokenProvider
implements StringRangeTree.SemanticTokenProvider<class_2520> {
    @NotNull
    private final StringRangeTree<class_2520> tree;
    @NotNull
    private final String input;

    public NbtSemanticTokenProvider(@NotNull StringRangeTree<class_2520> tree, @NotNull String input) {
        Intrinsics.checkNotNullParameter(tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.tree = tree;
        this.input = input;
    }

    @NotNull
    public final StringRangeTree<class_2520> getTree() {
        return this.tree;
    }

    @NotNull
    public final String getInput() {
        return this.input;
    }

    @Override
    @NotNull
    public StringRangeTree.TokenInfo getMapNameTokenInfo(@NotNull class_2520 map2) {
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        return new StringRangeTree.TokenInfo(TokenType.Companion.getPROPERTY(), 0);
    }

    @Override
    @Nullable
    public StringRangeTree.TokenInfo getNodeTokenInfo(@NotNull class_2520 node) {
        StringRangeTree.TokenInfo tokenInfo;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        class_2520 class_25202 = node;
        if (class_25202 instanceof class_2519) {
            tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getSTRING(), 0);
        } else if (class_25202 instanceof class_2514) {
            StringRange stringRange = this.tree.getRanges().get(node);
            Intrinsics.checkNotNull((Object)stringRange);
            char startChar = this.input.charAt(stringRange.getStart());
            switch (startChar) {
                case 'f': 
                case 't': {
                    tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getENUM_MEMBER(), 0);
                    break;
                }
                default: {
                    tokenInfo = new StringRangeTree.TokenInfo(TokenType.Companion.getNUMBER(), 0);
                    break;
                }
            }
        } else {
            tokenInfo = null;
        }
        return tokenInfo;
    }

    @NotNull
    public List<StringRangeTree.AdditionalToken> getAdditionalTokens(@NotNull class_2520 node) {
        List list;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node instanceof class_2483) {
            StringRange stringRange = this.tree.getRanges().get(node);
            Intrinsics.checkNotNull((Object)stringRange);
            int nodeStart = stringRange.getStart();
            list = this.input.length() > nodeStart + 2 && !StringReader.isQuotedStringStart((char)this.input.charAt(nodeStart + 1)) && this.input.charAt(nodeStart + 2) == ';' ? CollectionsKt.listOf((Object)new StringRangeTree.AdditionalToken(new StringRange(nodeStart + 1, nodeStart + 2), new StringRangeTree.TokenInfo(TokenType.Companion.getTYPE(), 0))) : CollectionsKt.emptyList();
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

