/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.mojang.brigadier.context.StringRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import net.papierkorb2292.command_crafter.editor.processing.TokenType;
import net.papierkorb2292.command_crafter.helper.UtilKt;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import net.papierkorb2292.command_crafter.parser.helper.SplitProcessedInputCursorMapper;
import org.eclipse.lsp4j.SemanticTokens;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J5\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000e\u0010\u000fJ7\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u0011J-\u0010\u0012\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0012\u0010\u0016J5\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0019\u0010\u000fJ!\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001a2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0015\u0010!\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0000\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010%\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00000#\u00a2\u0006\u0004\b%\u0010&J\r\u0010'\u001a\u00020\r\u00a2\u0006\u0004\b'\u0010(J\r\u0010*\u001a\u00020)\u00a2\u0006\u0004\b*\u0010+J\r\u0010,\u001a\u00020\u001a\u00a2\u0006\u0004\b,\u0010-R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010.\u001a\u0004\b/\u00100R$\u00103\u001a\u0012\u0012\u0004\u0012\u00020\u000601j\b\u0012\u0004\u0012\u00020\u0006`28\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b3\u00104R\u0016\u00105\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u0016\u00107\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00106\u00a8\u00068"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/SemanticTokensBuilder;", "", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "mappingInfo", "<init>", "(Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;)V", "", "line", "cursor", "length", "Lnet/papierkorb2292/command_crafter/editor/processing/TokenType;", "type", "modifiers", "", "add", "(IIILnet/papierkorb2292/command_crafter/editor/processing/TokenType;I)V", "typeId", "(IIIII)V", "addMultiline", "(IILnet/papierkorb2292/command_crafter/editor/processing/TokenType;I)V", "Lcom/mojang/brigadier/context/StringRange;", "range", "(Lcom/mojang/brigadier/context/StringRange;Lnet/papierkorb2292/command_crafter/editor/processing/TokenType;I)V", "lineDelta", "cursorDelta", "addRelative", "Lorg/eclipse/lsp4j/SemanticTokens;", "tokens", "", "resultId", "fill", "(Lorg/eclipse/lsp4j/SemanticTokens;Ljava/lang/String;)V", "other", "combineWith", "(Lnet/papierkorb2292/command_crafter/editor/processing/SemanticTokensBuilder;)V", "", "sortedOverlaps", "overlay", "(Ljava/util/Iterator;)V", "clear", "()V", "", "isEmpty", "()Z", "build", "()Lorg/eclipse/lsp4j/SemanticTokens;", "Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "getMappingInfo", "()Lnet/papierkorb2292/command_crafter/parser/FileMappingInfo;", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "data", "Ljava/util/ArrayList;", "lastLine", "I", "lastCursor", "command-crafter"})
public final class SemanticTokensBuilder {
    @NotNull
    private final FileMappingInfo mappingInfo;
    @NotNull
    private final ArrayList<Integer> data;
    private int lastLine;
    private int lastCursor;

    public SemanticTokensBuilder(@NotNull FileMappingInfo mappingInfo) {
        Intrinsics.checkNotNullParameter((Object)mappingInfo, (String)"mappingInfo");
        this.mappingInfo = mappingInfo;
        this.data = new ArrayList(100);
    }

    @NotNull
    public final FileMappingInfo getMappingInfo() {
        return this.mappingInfo;
    }

    public final void add(int line, int cursor, int length, @NotNull TokenType type, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.add(line, cursor, length, type.getId(), modifiers);
    }

    private final void add(int line, int cursor, int length, int typeId, int modifiers) {
        this.data.add(line - this.lastLine);
        if (this.lastLine != line) {
            this.lastLine = line;
            this.lastCursor = 0;
            v0 = this.data.add(cursor);
        } else {
            v0 = this.data.add(cursor - this.lastCursor);
        }
        this.data.add(length);
        this.data.add(typeId);
        this.data.add(modifiers);
        this.lastCursor = cursor;
    }

    public final void addMultiline(int cursor, int length, @NotNull TokenType type, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        List<String> lines = this.mappingInfo.getLines();
        if (lines.isEmpty()) {
            return;
        }
        int offsetCursor = cursor + this.mappingInfo.getReadSkippingChars();
        SplitProcessedInputCursorMapper cursorMapper = this.mappingInfo.getCursorMapper();
        int mappingIndex = UtilKt.binarySearch$default(cursorMapper.getTargetCursors(), 0, 0, arg_0 -> SemanticTokensBuilder.addMultiline$lambda$0(cursorMapper, offsetCursor, arg_0), 3, null);
        if (mappingIndex < 0) {
            mappingIndex = -(mappingIndex + 2);
        }
        int mappingRelativeCursor = offsetCursor;
        if (mappingIndex >= 0) {
            mappingRelativeCursor -= cursorMapper.getTargetCursors().get(mappingIndex);
        }
        int lineNumber = 0;
        int remainingLineLength = lines.get(lineNumber).length() + 1;
        int remainingLength = length;
        int prevMappingAbsoluteStart = 0;
        int lastLineCursor = 0;
        while (remainingLength > 0 && mappingIndex < cursorMapper.getTargetCursors().getSize()) {
            int remainingLengthCoveredByMapping = mappingIndex < 0 ? remainingLength : (mappingRelativeCursor < cursorMapper.getLengths().get(mappingIndex) ? Math.min(remainingLength, cursorMapper.getLengths().get(mappingIndex) - mappingRelativeCursor) : (mappingIndex == cursorMapper.getTargetCursors().getSize() - 1 ? remainingLength : Math.min(remainingLength, cursorMapper.getTargetCursors().get(mappingIndex + 1) - cursorMapper.getTargetCursors().get(mappingIndex) - mappingRelativeCursor)));
            remainingLength -= remainingLengthCoveredByMapping;
            int mappingAbsoluteStart = mappingIndex >= 0 ? cursorMapper.getSourceCursors().get(mappingIndex) + mappingRelativeCursor : mappingRelativeCursor;
            int cursorDelta = mappingAbsoluteStart - prevMappingAbsoluteStart;
            prevMappingAbsoluteStart = mappingAbsoluteStart;
            while (cursorDelta >= remainingLineLength) {
                cursorDelta -= remainingLineLength;
                if (++lineNumber >= lines.size()) {
                    return;
                }
                remainingLineLength = lines.get(lineNumber).length() + 1;
                lastLineCursor = 0;
            }
            remainingLineLength -= cursorDelta;
            int mappingAbsoluteEndExclusive = mappingAbsoluteStart + remainingLengthCoveredByMapping;
            int mappingAbsoluteEndInclusive = mappingAbsoluteEndExclusive - 1;
            if (cursorMapper.getExpandedCharEnds().containsKey(mappingAbsoluteEndInclusive)) {
                int expandedCharEndInclusive = cursorMapper.getExpandedCharEnds().get(mappingAbsoluteEndInclusive);
                remainingLengthCoveredByMapping = expandedCharEndInclusive + 1 - mappingAbsoluteStart;
            }
            while (remainingLengthCoveredByMapping > 0) {
                lastLineCursor += cursorDelta;
                if (remainingLengthCoveredByMapping <= remainingLineLength) {
                    this.add(lineNumber, lastLineCursor, remainingLengthCoveredByMapping, type, modifiers);
                    break;
                }
                int sectionLength = remainingLineLength;
                this.add(lineNumber, lastLineCursor, sectionLength, type, modifiers);
                if (++lineNumber >= lines.size()) {
                    return;
                }
                remainingLineLength = lines.get(lineNumber).length() + 1;
                remainingLengthCoveredByMapping -= sectionLength;
                lastLineCursor = 0;
                cursorDelta = 0;
            }
            mappingRelativeCursor = 0;
            ++mappingIndex;
        }
    }

    public final void addMultiline(@NotNull StringRange range, @NotNull TokenType type, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.addMultiline(range.getStart(), range.getLength(), type, modifiers);
    }

    public final void addRelative(int lineDelta, int cursorDelta, int length, @NotNull TokenType type, int modifiers) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.data.add(lineDelta);
        this.lastLine += lineDelta;
        this.data.add(cursorDelta);
        this.lastCursor = lineDelta == 0 ? cursorDelta : (this.lastCursor += cursorDelta);
        this.data.add(length);
        this.data.add(type.getId());
        this.data.add(modifiers);
    }

    public final void fill(@NotNull SemanticTokens tokens, @Nullable String resultId) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        tokens.setData((List)this.data);
        if (resultId != null) {
            tokens.setResultId(resultId);
        }
    }

    public static /* synthetic */ void fill$default(SemanticTokensBuilder semanticTokensBuilder, SemanticTokens semanticTokens, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        semanticTokensBuilder.fill(semanticTokens, string);
    }

    public final void combineWith(@NotNull SemanticTokensBuilder other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other.data.size() < 5) {
            return;
        }
        Integer n = other.data.get(0);
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
        int n2 = ((Number)n).intValue();
        Integer n3 = other.data.get(1);
        Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"get(...)");
        int n4 = ((Number)n3).intValue();
        Integer n5 = other.data.get(2);
        Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"get(...)");
        int n6 = ((Number)n5).intValue();
        Integer n7 = other.data.get(3);
        Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"get(...)");
        int n8 = ((Number)n7).intValue();
        Integer n9 = other.data.get(4);
        Intrinsics.checkNotNullExpressionValue((Object)n9, (String)"get(...)");
        this.add(n2, n4, n6, n8, ((Number)n9).intValue());
        Iterator<Integer> iterator = other.data.subList(5, other.data.size()).iterator();
        while (iterator.hasNext()) {
            int value = ((Number)iterator.next()).intValue();
            Integer n10 = value;
            ((Collection)this.data).add(n10);
        }
        this.lastLine = other.lastLine;
        this.lastCursor = other.lastCursor;
    }

    public final void overlay(@NotNull Iterator<SemanticTokensBuilder> sortedOverlaps) {
        Intrinsics.checkNotNullParameter(sortedOverlaps, (String)"sortedOverlaps");
        int currentTokenIndex = 0;
        this.lastLine = 0;
        this.lastCursor = 0;
        Iterator<SemanticTokensBuilder> iterator = sortedOverlaps;
        block0: while (iterator.hasNext()) {
            SemanticTokensBuilder overlap = iterator.next();
            int srcLine = 0;
            int srcCursor = 0;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)overlap.data.size())), (int)5);
            int i2 = intProgression.getFirst();
            int n = intProgression.getLast();
            int n2 = intProgression.getStep();
            if ((n2 <= 0 || i2 > n) && (n2 >= 0 || n > i2)) continue;
            while (true) {
                block13: {
                    Integer n3 = overlap.data.get(i2);
                    Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"get(...)");
                    srcLine += ((Number)n3).intValue();
                    Integer n4 = overlap.data.get(i2);
                    srcCursor = ((Number)overlap.data.get(i2 + 1)).intValue() + (n4 != null && n4 == 0 ? srcCursor : 0);
                    Integer n5 = overlap.data.get(i2 + 2);
                    Intrinsics.checkNotNullExpressionValue((Object)n5, (String)"get(...)");
                    int srcLength = ((Number)n5).intValue();
                    Integer n6 = overlap.data.get(i2 + 3);
                    Intrinsics.checkNotNullExpressionValue((Object)n6, (String)"get(...)");
                    int srcTypeId = ((Number)n6).intValue();
                    Integer n7 = overlap.data.get(i2 + 4);
                    Intrinsics.checkNotNullExpressionValue((Object)n7, (String)"get(...)");
                    int srcModifiers = ((Number)n7).intValue();
                    while (currentTokenIndex < this.data.size()) {
                        Integer n8 = this.data.get(currentTokenIndex);
                        Intrinsics.checkNotNullExpressionValue((Object)n8, (String)"get(...)");
                        int newDestLine = this.lastLine + ((Number)n8).intValue();
                        Integer n9 = this.data.get(currentTokenIndex);
                        int newDestCursor = ((Number)this.data.get(currentTokenIndex + 1)).intValue() + (n9 != null && n9 == 0 ? this.lastCursor : 0);
                        Integer n10 = this.data.get(currentTokenIndex + 2);
                        Intrinsics.checkNotNullExpressionValue((Object)n10, (String)"get(...)");
                        int destLength = ((Number)n10).intValue();
                        Integer n11 = this.data.get(currentTokenIndex + 3);
                        Intrinsics.checkNotNullExpressionValue((Object)n11, (String)"get(...)");
                        int destTypeId = ((Number)n11).intValue();
                        Integer n12 = this.data.get(currentTokenIndex + 4);
                        Intrinsics.checkNotNullExpressionValue((Object)n12, (String)"get(...)");
                        int destModifiers = ((Number)n12).intValue();
                        if (newDestLine > srcLine || newDestLine == srcLine && newDestCursor + destLength > srcCursor) {
                            if (newDestLine > srcLine || newDestCursor > srcCursor + srcLength) {
                                this.data.add(currentTokenIndex, srcLine - this.lastLine);
                                this.data.add(currentTokenIndex + 1, srcLine == this.lastLine ? srcCursor - this.lastCursor : srcCursor);
                                this.data.add(currentTokenIndex + 2, srcLength);
                                this.data.add(currentTokenIndex + 3, srcTypeId);
                                this.data.add(currentTokenIndex + 4, srcModifiers);
                                this.lastLine = srcLine;
                                this.lastCursor = srcCursor;
                                this.data.set(currentTokenIndex += 5, newDestLine - srcLine);
                                this.data.set(currentTokenIndex + 1, newDestLine == srcLine ? newDestCursor - srcCursor : newDestCursor);
                            } else {
                                boolean hasRemainingDest;
                                int cursorDiff = 0;
                                if (newDestCursor < srcCursor) {
                                    cursorDiff = srcCursor - newDestCursor;
                                    this.data.set(currentTokenIndex + 2, cursorDiff);
                                    currentTokenIndex += 5;
                                } else {
                                    this.data.subList(currentTokenIndex, currentTokenIndex + 5).clear();
                                    cursorDiff = srcCursor - this.lastCursor;
                                }
                                this.data.add(currentTokenIndex, 0);
                                this.data.add(currentTokenIndex + 1, cursorDiff);
                                this.data.add(currentTokenIndex + 2, srcLength);
                                this.data.add(currentTokenIndex + 3, srcTypeId);
                                this.data.add(currentTokenIndex + 4, srcModifiers);
                                boolean bl = hasRemainingDest = newDestCursor + destLength > srcCursor + srcLength;
                                if (hasRemainingDest) {
                                    int remainingLength = newDestCursor + destLength - srcCursor - srcLength;
                                    this.data.add(currentTokenIndex += 5, 0);
                                    this.data.add(currentTokenIndex + 1, srcLength);
                                    this.data.add(currentTokenIndex + 2, remainingLength);
                                    this.data.add(currentTokenIndex + 3, destTypeId);
                                    this.data.add(currentTokenIndex + 4, destModifiers);
                                    this.lastLine = srcLine;
                                    this.lastCursor = srcCursor;
                                } else {
                                    this.lastLine = newDestLine;
                                    this.lastCursor = newDestCursor;
                                }
                                if (currentTokenIndex + 5 < this.data.size()) {
                                    Integer n13 = this.data.get(currentTokenIndex + 5);
                                    if (n13 != null && n13 == 0) {
                                        int originalCursorDiff = srcCursor - newDestCursor;
                                        ArrayList<Integer> arrayList = this.data;
                                        int n14 = currentTokenIndex + 6;
                                        arrayList.set(n14, ((Number)arrayList.get(n14)).intValue() - (hasRemainingDest ? originalCursorDiff + srcLength : originalCursorDiff));
                                    }
                                }
                            }
                            break block13;
                        }
                        this.lastLine = newDestLine;
                        this.lastCursor = newDestCursor;
                        currentTokenIndex += 5;
                    }
                    this.add(srcLine, srcCursor, srcLength, srcTypeId, srcModifiers);
                    currentTokenIndex += 5;
                }
                if (i2 == n) continue block0;
                i2 += n2;
            }
        }
        while (currentTokenIndex < this.data.size()) {
            Integer n = this.data.get(currentTokenIndex);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"get(...)");
            this.lastLine += ((Number)n).intValue();
            Integer n15 = this.data.get(currentTokenIndex);
            int n16 = n15 != null && n15 == 0 ? this.lastCursor : 0;
            Integer n17 = this.data.get(currentTokenIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)n17, (String)"get(...)");
            this.lastCursor = n16 + ((Number)n17).intValue();
            currentTokenIndex += 5;
        }
    }

    public final void clear() {
        this.data.clear();
        this.lastLine = 0;
        this.lastCursor = 0;
    }

    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @NotNull
    public final SemanticTokens build() {
        return new SemanticTokens((List)this.data);
    }

    private static final int addMultiline$lambda$0(SplitProcessedInputCursorMapper $cursorMapper, int $offsetCursor, int index) {
        return $cursorMapper.getTargetCursors().get(index) + $cursorMapper.getLengths().get(index) <= $offsetCursor ? -1 : ($cursorMapper.getTargetCursors().get(index) > $offsetCursor ? 1 : 0);
    }
}

