/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.processing;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.optionals.OptionalsKt;
import kotlin.text.StringsKt;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.OpenFile;
import net.papierkorb2292.command_crafter.editor.processing.DummySemanticTokenProvider;
import net.papierkorb2292.command_crafter.editor.processing.FileTypeDispatchingAnalyzer;
import net.papierkorb2292.command_crafter.editor.processing.PackContentFileType;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTree;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTreeJsonReader;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.FileAnalyseHandler;
import net.papierkorb2292.command_crafter.parser.FileMappingInfo;
import net.papierkorb2292.command_crafter.string_range_gson.Strictness;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0014R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonResourceAnalyzer;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/FileAnalyseHandler;", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "packContentFileType", "Lcom/mojang/serialization/Decoder;", "fileDecoder", "", "analyzerConfigPath", "<init>", "(Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;Lcom/mojang/serialization/Decoder;Ljava/lang/String;)V", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "file", "", "canHandle", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;)Z", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "languageServer", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyze", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;)Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "Lcom/mojang/serialization/Decoder;", "Ljava/lang/String;", "Companion", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nStringRangeTreeJsonResourceAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringRangeTreeJsonResourceAnalyzer.kt\nnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonResourceAnalyzer\n+ 2 Util.kt\nnet/papierkorb2292/command_crafter/helper/UtilKt\n*L\n1#1,74:1\n57#2,5:75\n*S KotlinDebug\n*F\n+ 1 StringRangeTreeJsonResourceAnalyzer.kt\nnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonResourceAnalyzer\n*L\n32#1:75,5\n*E\n"})
public final class StringRangeTreeJsonResourceAnalyzer
implements FileAnalyseHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PackContentFileType packContentFileType;
    @NotNull
    private final Decoder<?> fileDecoder;
    @NotNull
    private final String analyzerConfigPath;
    @NotNull
    public static final String JSON_ANALYZER_CONFIG_PATH_PREFIX = ".json";
    @NotNull
    private static final ThreadLocal<class_7225.class_7226<?>> CURRENT_TAG_ANALYZING_REGISTRY = new ThreadLocal();

    public StringRangeTreeJsonResourceAnalyzer(@NotNull PackContentFileType packContentFileType, @NotNull Decoder<?> fileDecoder, @NotNull String analyzerConfigPath) {
        Intrinsics.checkNotNullParameter((Object)((Object)packContentFileType), (String)"packContentFileType");
        Intrinsics.checkNotNullParameter(fileDecoder, (String)"fileDecoder");
        Intrinsics.checkNotNullParameter((Object)analyzerConfigPath, (String)"analyzerConfigPath");
        this.packContentFileType = packContentFileType;
        this.fileDecoder = fileDecoder;
        this.analyzerConfigPath = analyzerConfigPath;
    }

    @Override
    public boolean canHandle(@NotNull OpenFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return StringsKt.endsWith$default((String)file.getParsedUri().getPath(), (String)JSON_ANALYZER_CONFIG_PATH_PREFIX, (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)file.getParsedUri().getPath(), (String)".mcmeta", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public AnalyzingResult analyze(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        AnalyzingResult analyzingResult;
        class_2378 tagRegistry;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        String contentTypeFilePath = this.packContentFileType.getContentTypePath();
        String tagPrefix = "tags/";
        if (StringsKt.startsWith$default((String)contentTypeFilePath, (String)tagPrefix, (boolean)false, (int)2, null)) {
            class_5455 class_54552 = languageServer.getDynamicRegistryManager();
            String string = contentTypeFilePath.substring(tagPrefix.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Optional optional = class_54552.method_46759(class_5321.method_29180((class_2960)class_2960.method_60656((String)string)));
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"getOptional(...)");
            v3 = (class_2378)OptionalsKt.getOrNull((Optional)optional);
        } else {
            v3 = tagRegistry = null;
        }
        if (tagRegistry != null) {
            ThreadLocal<class_7225.class_7226<?>> $this$runWithValue$iv = CURRENT_TAG_ANALYZING_REGISTRY;
            boolean $i$f$runWithValue = false;
            $this$runWithValue$iv.set((class_7225.class_7226<?>)tagRegistry);
            try {
                boolean bl = false;
                AnalyzingResult analyzingResult2 = Companion.analyze(file, languageServer, this.fileDecoder);
                analyzingResult = analyzingResult2;
            }
            finally {
                $this$runWithValue$iv.remove();
            }
        } else {
            analyzingResult = Companion.analyze(file, languageServer, this.fileDecoder);
        }
        AnalyzingResult analyzingResult3 = analyzingResult;
        Object[] objectArray = new String[]{JSON_ANALYZER_CONFIG_PATH_PREFIX + this.analyzerConfigPath, JSON_ANALYZER_CONFIG_PATH_PREFIX, ""};
        analyzingResult3.clearDisabledFeatures(languageServer.getFeatureConfig(), CollectionsKt.listOf((Object[])objectArray));
        return analyzingResult3;
    }

    @Override
    @NotNull
    public CompletableFuture<AnalyzingResult> analyzeAsync(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        return FileAnalyseHandler.DefaultImpls.analyzeAsync(this, file, languageServer);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\b2\u0016\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004\u00a2\u0006\u0004\b\t\u0010\nJ)\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0015\u001a\u00020\u00148\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0016R!\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00180\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonResourceAnalyzer$Companion;", "", "<init>", "()V", "", "Lnet/papierkorb2292/command_crafter/editor/processing/PackContentFileType;", "Lcom/mojang/serialization/Codec;", "resourceTypes", "", "addJsonAnalyzers", "(Ljava/util/Map;)V", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "file", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "languageServer", "Lcom/mojang/serialization/Decoder;", "fileDecoder", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyze", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;Lcom/mojang/serialization/Decoder;)Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "", "JSON_ANALYZER_CONFIG_PATH_PREFIX", "Ljava/lang/String;", "Ljava/lang/ThreadLocal;", "Lnet/minecraft/class_7225$class_7226;", "CURRENT_TAG_ANALYZING_REGISTRY", "Ljava/lang/ThreadLocal;", "getCURRENT_TAG_ANALYZING_REGISTRY", "()Ljava/lang/ThreadLocal;", "command-crafter"})
    @SourceDebugExtension(value={"SMAP\nStringRangeTreeJsonResourceAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringRangeTreeJsonResourceAnalyzer.kt\nnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonResourceAnalyzer$Companion\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n465#2:75\n415#2:76\n1252#3,4:77\n*S KotlinDebug\n*F\n+ 1 StringRangeTreeJsonResourceAnalyzer.kt\nnet/papierkorb2292/command_crafter/editor/processing/StringRangeTreeJsonResourceAnalyzer$Companion\n*L\n49#1:75\n49#1:76\n49#1:77,4\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ThreadLocal<class_7225.class_7226<?>> getCURRENT_TAG_ANALYZING_REGISTRY() {
            return CURRENT_TAG_ANALYZING_REGISTRY;
        }

        /*
         * WARNING - void declaration
         */
        public final void addJsonAnalyzers(@NotNull Map<PackContentFileType, ? extends Codec<?>> resourceTypes) {
            void $this$mapValuesTo$iv$iv;
            Intrinsics.checkNotNullParameter(resourceTypes, (String)"resourceTypes");
            Map<PackContentFileType, FileAnalyseHandler> map2 = FileTypeDispatchingAnalyzer.INSTANCE.getAnalyzers();
            Map<PackContentFileType, Codec<?>> $this$mapValues$iv = resourceTypes;
            boolean $i$f$mapValues = false;
            Map<PackContentFileType, Codec<?>> map3 = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void entry;
                void it$iv$iv;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Map map4 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map5 = map4;
                boolean bl2 = false;
                StringRangeTreeJsonResourceAnalyzer stringRangeTreeJsonResourceAnalyzer = new StringRangeTreeJsonResourceAnalyzer((PackContentFileType)((Object)entry.getKey()), (Decoder)entry.getValue(), "." + ((PackContentFileType)((Object)entry.getKey())).getContentTypePath());
                map5.put(k, stringRangeTreeJsonResourceAnalyzer);
            }
            Map map6 = destination$iv$iv;
            map2.putAll(map6);
        }

        @NotNull
        public final AnalyzingResult analyze(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer, @NotNull Decoder<?> fileDecoder) {
            StringRangeTree<JsonElement> stringRangeTree;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
            Intrinsics.checkNotNullParameter(fileDecoder, (String)"fileDecoder");
            List<String> lines = file.stringifyLines();
            AnalyzingResult result = new AnalyzingResult(new FileMappingInfo(lines, null, 0, 0, 14, null), new Position(), null, 4, null);
            String concatenatedLines = CollectionsKt.joinToString$default((Iterable)lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            StringReader reader = new StringReader(concatenatedLines);
            try {
                stringRangeTree = new StringRangeTreeJsonReader(reader).read(Strictness.LENIENT, true);
            }
            catch (IOException e) {
                return result;
            }
            StringRangeTree<JsonElement> parsedStringRangeTree = stringRangeTree;
            StringRangeTree.TreeOperations treeOperations = StringRangeTree.TreeOperations.copy$default(StringRangeTree.TreeOperations.Companion.forJson(parsedStringRangeTree, concatenatedLines).withRegistry((class_7225.class_7874)languageServer.getDynamicRegistryManager()), null, null, DummySemanticTokenProvider.INSTANCE, null, null, null, null, null, null, 507, null);
            treeOperations.analyzeFull(result, true, fileDecoder);
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

