/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer;

import com.mojang.serialization.Decoder;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.papierkorb2292.command_crafter.editor.MinecraftLanguageServer;
import net.papierkorb2292.command_crafter.editor.OpenFile;
import net.papierkorb2292.command_crafter.editor.processing.StringRangeTreeJsonResourceAnalyzer;
import net.papierkorb2292.command_crafter.editor.processing.helper.AnalyzingResult;
import net.papierkorb2292.command_crafter.editor.processing.helper.FileAnalyseHandler;
import net.papierkorb2292.command_crafter.editor.scoreboardStorageViewer.ServerScoreboardStorageFileSystem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lnet/papierkorb2292/command_crafter/editor/scoreboardStorageViewer/ScoreboardFileAnalyzer;", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/FileAnalyseHandler;", "<init>", "()V", "Lnet/papierkorb2292/command_crafter/editor/OpenFile;", "file", "", "canHandle", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;)Z", "Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;", "languageServer", "Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "analyze", "(Lnet/papierkorb2292/command_crafter/editor/OpenFile;Lnet/papierkorb2292/command_crafter/editor/MinecraftLanguageServer;)Lnet/papierkorb2292/command_crafter/editor/processing/helper/AnalyzingResult;", "", "ANALYZER_CONFIG_PATH", "Ljava/lang/String;", "command-crafter"})
public final class ScoreboardFileAnalyzer
implements FileAnalyseHandler {
    @NotNull
    public static final ScoreboardFileAnalyzer INSTANCE = new ScoreboardFileAnalyzer();
    @NotNull
    private static final String ANALYZER_CONFIG_PATH = ".scoreboardStorage";

    private ScoreboardFileAnalyzer() {
    }

    @Override
    public boolean canHandle(@NotNull OpenFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getParsedUri().getScheme(), (Object)"scoreboardStorage") && StringsKt.startsWith$default((String)file.getParsedUri().getPath(), (String)"/scoreboards/", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)file.getParsedUri().getPath(), (String)".json", (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public AnalyzingResult analyze(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)languageServer, (String)"languageServer");
        AnalyzingResult analyzingResult = StringRangeTreeJsonResourceAnalyzer.Companion.analyze(file, languageServer, (Decoder)ServerScoreboardStorageFileSystem.Companion.getOBJECTIVE_CODEC());
        Object[] objectArray = new String[]{".json.scoreboardStorage", ".json", ""};
        analyzingResult.clearDisabledFeatures(languageServer.getFeatureConfig(), CollectionsKt.listOf((Object[])objectArray));
        return analyzingResult;
    }

    @Override
    @NotNull
    public CompletableFuture<AnalyzingResult> analyzeAsync(@NotNull OpenFile file, @NotNull MinecraftLanguageServer languageServer) {
        return FileAnalyseHandler.DefaultImpls.analyzeAsync(this, file, languageServer);
    }
}

