/*
 * Decompiled with CFR 0.152.
 */
package net.papierkorb2292.command_crafter.parser;

import com.google.common.io.Files;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3259;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import net.papierkorb2292.command_crafter.mixin.parser.DirectoryResourcePackAccessor;
import net.papierkorb2292.command_crafter.parser.DatapackBuildArgs;
import net.papierkorb2292.command_crafter.parser.helper.RawResource;
import net.papierkorb2292.command_crafter.parser.helper.ZipFileProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0002 !B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJC\u0010\u0015\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R&\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u00180\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006\""}, d2={"Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator;", "", "<init>", "()V", "Lnet/minecraft/class_2960;", "id", "Lnet/papierkorb2292/command_crafter/parser/helper/RawResource;", "resource", "", "addResource", "(Lnet/minecraft/class_2960;Lnet/papierkorb2292/command_crafter/parser/helper/RawResource;)V", "Ljava/util/zip/ZipOutputStream;", "zipOutput", "createResources", "(Ljava/util/zip/ZipOutputStream;)V", "currentId", "parentFunctionId", "", "", "", "subResourceNumbering", "createResource", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_2960;Lnet/papierkorb2292/command_crafter/parser/helper/RawResource;Ljava/util/zip/ZipOutputStream;Ljava/util/Map;)V", "", "Lkotlin/Pair;", "resources", "Ljava/util/List;", "Ljava/util/LinkedList;", "resourceStack", "Ljava/util/LinkedList;", "getResourceStack", "()Ljava/util/LinkedList;", "Companion", "DataTypeProcessor", "command-crafter"})
@SourceDebugExtension(value={"SMAP\nRawZipResourceCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawZipResourceCreator.kt\nnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1563#2:158\n1634#2,3:159\n37#3:162\n36#3,3:163\n1#4:166\n*S KotlinDebug\n*F\n+ 1 RawZipResourceCreator.kt\nnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator\n*L\n138#1:158\n138#1:159,3\n147#1:162\n147#1:163,3\n*E\n"})
public final class RawZipResourceCreator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<class_2960, RawResource>> resources = new ArrayList();
    @NotNull
    private final LinkedList<RawResource> resourceStack = new LinkedList();
    @NotNull
    private static final DynamicCommandExceptionType UNKNOWN_DATAPACK_EXCEPTION = new DynamicCommandExceptionType(RawZipResourceCreator::UNKNOWN_DATAPACK_EXCEPTION$lambda$7);
    @NotNull
    private static final Dynamic2CommandExceptionType PROCESSOR_EXCEPTION = new Dynamic2CommandExceptionType(RawZipResourceCreator::PROCESSOR_EXCEPTION$lambda$8);
    @NotNull
    private static final SimpleCommandExceptionType MISSING_PACK_META_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_30163((String)"Datapack is missing pack.mcmeta"));
    @NotNull
    private static final List<DataTypeProcessor> DATA_TYPE_PROCESSORS = new ArrayList();

    @NotNull
    public final LinkedList<RawResource> getResourceStack() {
        return this.resourceStack;
    }

    public final void addResource(@NotNull class_2960 id, @NotNull RawResource resource) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        ((Collection)this.resources).add(TuplesKt.to((Object)id, (Object)resource));
    }

    private final void createResources(ZipOutputStream zipOutput) {
        HashMap subResourceNumbering = new HashMap();
        for (Pair<class_2960, RawResource> pair : this.resources) {
            class_2960 id = (class_2960)pair.component1();
            RawResource resource = (RawResource)pair.component2();
            this.createResource(id, id, resource, zipOutput, subResourceNumbering);
            subResourceNumbering.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createResource(class_2960 currentId, class_2960 parentFunctionId, RawResource resource, ZipOutputStream zipOutput, Map<String, Integer> subResourceNumbering) {
        List list;
        void $this$mapTo$iv$iv;
        resource.setId(currentId);
        Iterable $this$map$iv = resource.getContent();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void either;
            Either either2 = (Either)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((String)either.map(arg_0 -> RawZipResourceCreator.createResource$lambda$5$lambda$1(RawZipResourceCreator::createResource$lambda$5$lambda$0, arg_0), arg_0 -> RawZipResourceCreator.createResource$lambda$5$lambda$4(arg_0 -> RawZipResourceCreator.createResource$lambda$5$lambda$3(parentFunctionId, subResourceNumbering, this, zipOutput, arg_0), arg_0)));
        }
        List $this$createResource_u24lambda_u246 = list = (List)destination$iv$iv;
        boolean bl = false;
        zipOutput.putNextEntry(new ZipEntry(Path.of(class_3264.field_14190.method_14413() + "/" + currentId.method_12836(), new String[0]).resolve(resource.getType().getPrefix()).resolve(currentId.method_12832()) + "." + resource.getType().getFileExtension()));
        String[] stringArray = (String[])zipOutput;
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset(...)");
        Charset $i$f$mapTo22 = charset;
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)stringArray, $i$f$mapTo22);
        Collection $this$toTypedArray$iv = $this$createResource_u24lambda_u246;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        stringArray = thisCollection$iv.toArray(new String[0]);
        ((OutputStreamWriter)StringsKt.append((Appendable)outputStreamWriter, (CharSequence[])Arrays.copyOf(stringArray, stringArray.length))).flush();
    }

    private static final String createResource$lambda$5$lambda$0(String it) {
        return it;
    }

    private static final String createResource$lambda$5$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final String createResource$lambda$5$lambda$3(class_2960 $parentFunctionId, Map $subResourceNumbering, RawZipResourceCreator this$0, ZipOutputStream $zipOutput, RawResource it) {
        class_2960 class_29602 = it.getId();
        if (class_29602 != null) {
            class_2960 $this$createResource_u24lambda_u245_u24lambda_u243_u24lambda_u242 = class_29602;
            boolean bl = false;
            return $this$createResource_u24lambda_u245_u24lambda_u243_u24lambda_u242.toString();
        }
        class_2960 childId = class_2960.method_60655((String)$parentFunctionId.method_12836(), (String)($parentFunctionId.method_12832() + "--" + RawZipResourceCreator.Companion.numberSubResource($subResourceNumbering, it.getType().getPrefix()) + "--craftergen"));
        Intrinsics.checkNotNull((Object)childId);
        Intrinsics.checkNotNull((Object)it);
        this$0.createResource(childId, $parentFunctionId, it, $zipOutput, $subResourceNumbering);
        return childId.toString();
    }

    private static final String createResource$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    private static final Message UNKNOWN_DATAPACK_EXCEPTION$lambda$7(Object it) {
        return (Message)class_2561.method_30163((String)("Datapack " + it + " is of unknown type and cannot be build"));
    }

    private static final Message PROCESSOR_EXCEPTION$lambda$8(Object id, Object exception) {
        return (Message)class_2561.method_30163((String)("Error while processing resource '" + id + "' for datapack build: " + exception));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJC\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J+\u0010\u001e\u001a\u00020\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b0\u00192\u0006\u0010\u001d\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010$\u001a\u00020#8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001d\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)8\u0006\u00a2\u0006\f\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\u00a8\u0006/"}, d2={"Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator$Companion;", "", "<init>", "()V", "Lnet/minecraft/class_3262;", "pack", "Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;", "args", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2172;", "dispatcher", "Ljava/util/zip/ZipOutputStream;", "output", "", "buildDatapack", "(Lnet/minecraft/class_3262;Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;Lcom/mojang/brigadier/CommandDispatcher;Ljava/util/zip/ZipOutputStream;)V", "Lnet/minecraft/class_2960;", "fileId", "Lnet/minecraft/class_7367;", "Ljava/io/InputStream;", "content", "Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator;", "resourceCreator", "processFile", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_7367;Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator;Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;Lcom/mojang/brigadier/CommandDispatcher;)V", "", "", "", "map", "type", "numberSubResource", "(Ljava/util/Map;Ljava/lang/String;)I", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "UNKNOWN_DATAPACK_EXCEPTION", "Lcom/mojang/brigadier/exceptions/DynamicCommandExceptionType;", "Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "PROCESSOR_EXCEPTION", "Lcom/mojang/brigadier/exceptions/Dynamic2CommandExceptionType;", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "MISSING_PACK_META_EXCEPTION", "Lcom/mojang/brigadier/exceptions/SimpleCommandExceptionType;", "", "Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator$DataTypeProcessor;", "DATA_TYPE_PROCESSORS", "Ljava/util/List;", "getDATA_TYPE_PROCESSORS", "()Ljava/util/List;", "command-crafter"})
    @SourceDebugExtension(value={"SMAP\nRawZipResourceCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RawZipResourceCreator.kt\nnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<DataTypeProcessor> getDATA_TYPE_PROCESSORS() {
            return DATA_TYPE_PROCESSORS;
        }

        public final void buildDatapack(@NotNull class_3262 pack, @NotNull DatapackBuildArgs args, @NotNull CommandDispatcher<class_2172> dispatcher, @NotNull ZipOutputStream output) {
            Intrinsics.checkNotNullParameter((Object)pack, (String)"pack");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            Intrinsics.checkNotNullParameter(dispatcher, (String)"dispatcher");
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            RawZipResourceCreator resourceCreator = new RawZipResourceCreator();
            class_3262 class_32622 = pack;
            if (class_32622 instanceof class_3259) {
                Path dataRoot = ((DirectoryResourcePackAccessor)pack).getRoot().resolve(class_3264.field_14190.method_14413());
                for (String namespace : ((class_3259)pack).method_14406(class_3264.field_14190)) {
                    class_3259.method_45183((String)namespace, (Path)dataRoot.resolve(namespace), (List)CollectionsKt.emptyList(), (arg_0, arg_1) -> Companion.buildDatapack$lambda$0(resourceCreator, args, dispatcher, arg_0, arg_1));
                }
            } else if (class_32622 instanceof class_3258) {
                ZipFile zipFile = ((ZipFileProvider)pack).command_crafter$getZipFile();
                String dataDirectory = class_3264.field_14190.method_14413();
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
                Iterator iterator = CollectionsKt.iterator(enumeration);
                while (iterator.hasNext()) {
                    Path entryPath;
                    ZipEntry entry = (ZipEntry)iterator.next();
                    String string = entry.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Intrinsics.checkNotNull((Object)dataDirectory);
                    if (!StringsKt.startsWith$default((String)string, (String)dataDirectory, (boolean)false, (int)2, null) || (entryPath = Path.of(dataDirectory, new String[0]).relativize(Path.of(entry.getName(), new String[0]))).getParent() == null) continue;
                    Path namespace = entryPath.getName(0);
                    Path path = namespace.relativize(entryPath);
                    class_2960 class_29602 = class_2960.method_60655((String)((Object)namespace).toString(), (String)StringsKt.replace$default((String)((Object)path).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null));
                    Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"of(...)");
                    class_7367 class_73672 = class_7367.create((ZipFile)zipFile, (ZipEntry)entry);
                    Intrinsics.checkNotNullExpressionValue((Object)class_73672, (String)"create(...)");
                    this.processFile(class_29602, (class_7367<InputStream>)class_73672, resourceCreator, args, dispatcher);
                }
            } else {
                throw UNKNOWN_DATAPACK_EXCEPTION.create((Object)pack.method_14409());
            }
            String[] stringArray = new String[]{"pack.mcmeta"};
            class_7367 class_73673 = pack.method_14410(stringArray);
            if (class_73673 == null) {
                throw MISSING_PACK_META_EXCEPTION.create();
            }
            InputStream packMeta = (InputStream)class_73673.get();
            output.putNextEntry(new ZipEntry("pack.mcmeta"));
            Intrinsics.checkNotNull((Object)packMeta);
            ByteStreamsKt.copyTo$default((InputStream)packMeta, (OutputStream)output, (int)0, (int)2, null);
            packMeta.close();
            resourceCreator.createResources(output);
        }

        private final void processFile(class_2960 fileId, class_7367<InputStream> content, RawZipResourceCreator resourceCreator, DatapackBuildArgs args, CommandDispatcher<class_2172> dispatcher) {
            Object object;
            Object object2;
            String string = Files.getFileExtension((String)fileId.method_12832());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileExtension(...)");
            String resourceExtension = string;
            String string2 = fileId.method_12836();
            String string3 = fileId.method_12832();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
            String string4 = string3;
            int n = 0;
            int n2 = fileId.method_12832().length() - resourceExtension.length() - 1;
            String string5 = string4.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            class_2960 resourceId = class_2960.method_60655((String)string2, (String)string5);
            for (DataTypeProcessor processor : this.getDATA_TYPE_PROCESSORS()) {
                String string6 = resourceId.method_12832();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
                if (!StringsKt.startsWith$default((String)string6, (String)processor.getType(), (boolean)false, (int)2, null)) continue;
                InputStream input = (InputStream)content.get();
                Intrinsics.checkNotNull((Object)input);
                object2 = input;
                object = Charsets.UTF_8;
                Reader reader = new InputStreamReader((InputStream)object2, (Charset)object);
                int n3 = 8192;
                BufferedReader reader2 = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n3);
                Path path = Path.of(resourceId.method_12832(), new String[0]);
                class_2960 id = class_2960.method_60655((String)resourceId.method_12836(), (String)StringsKt.replace$default((String)((Object)Path.of(processor.getType(), new String[0]).relativize(path)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null));
                try {
                    if (processor.shouldProcess(args)) {
                        Intrinsics.checkNotNull((Object)id);
                        processor.process(args, id, reader2, resourceCreator, dispatcher);
                        reader2.close();
                        return;
                    }
                    Intrinsics.checkNotNull((Object)id);
                    processor.validate(args, id, reader2, dispatcher);
                }
                catch (Exception e) {
                    throw PROCESSOR_EXCEPTION.create((Object)fileId, (Object)e.getMessage());
                }
            }
            InputStream input = (InputStream)content.get();
            RawResource $this$processFile_u24lambda_u241 = new RawResource(new RawResource.RawResourceType("", resourceExtension));
            boolean bl = false;
            object2 = $this$processFile_u24lambda_u241.getContent();
            byte[] byArray = input.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            object = byArray;
            object2.add(Either.left((Object)new String((byte[])object, Charsets.UTF_8)));
            ((Collection)resourceCreator.resources).add(TuplesKt.to((Object)resourceId, (Object)$this$processFile_u24lambda_u241));
            input.close();
        }

        private final int numberSubResource(Map<String, Integer> map2, String type) {
            int n;
            Integer n2 = map2.get(type);
            int it = n = n2 != null ? n2 : 0;
            boolean bl = false;
            map2.put(type, it + 1);
            return n;
        }

        private static final void buildDatapack$lambda$0(RawZipResourceCreator $resourceCreator, DatapackBuildArgs $args, CommandDispatcher $dispatcher, class_2960 fileId, class_7367 content) {
            Intrinsics.checkNotNull((Object)fileId);
            Intrinsics.checkNotNull((Object)content);
            Companion.processFile(fileId, (class_7367<InputStream>)content, $resourceCreator, $args, (CommandDispatcher<class_2172>)$dispatcher);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J=\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&\u00a2\u0006\u0004\b\u0011\u0010\u0012J5\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0018\u001a\u00020\u00158&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator$DataTypeProcessor;", "", "Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;", "args", "", "shouldProcess", "(Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;)Z", "Lnet/minecraft/class_2960;", "id", "Ljava/io/BufferedReader;", "content", "Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator;", "resourceCreator", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/class_2172;", "dispatcher", "", "process", "(Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;Lnet/minecraft/class_2960;Ljava/io/BufferedReader;Lnet/papierkorb2292/command_crafter/parser/RawZipResourceCreator;Lcom/mojang/brigadier/CommandDispatcher;)V", "validate", "(Lnet/papierkorb2292/command_crafter/parser/DatapackBuildArgs;Lnet/minecraft/class_2960;Ljava/io/BufferedReader;Lcom/mojang/brigadier/CommandDispatcher;)V", "", "getType", "()Ljava/lang/String;", "type", "command-crafter"})
    public static interface DataTypeProcessor {
        @NotNull
        public String getType();

        public boolean shouldProcess(@NotNull DatapackBuildArgs var1);

        public void process(@NotNull DatapackBuildArgs var1, @NotNull class_2960 var2, @NotNull BufferedReader var3, @NotNull RawZipResourceCreator var4, @NotNull CommandDispatcher<class_2172> var5);

        public void validate(@NotNull DatapackBuildArgs var1, @NotNull class_2960 var2, @NotNull BufferedReader var3, @NotNull CommandDispatcher<class_2172> var4);
    }
}

